/**
 * 
 */

Ext.define('Academia.view.program.programDetails.programBatchDetails.periodsBreaks.ProgramPeriodsBreaksForm', {
    extend: 'Ext.window.Window',
    alias: 'widget.programperiodsbreaksformwindow',
    modal: true,
    autoScroll:true,
    title: getCommonTranslation('PERIOD_BREAKS_FORM'),
    maxHeight:600,
    items: [{
        xtype: 'customform',
        customFieldEntity:CONSTANTS.BATCH_DETAIL_PERIOD_BREAK_CUSTOM_FIELD,
        id: 'programPeriodsBreaksForm',
        itemId: 'programPeriodsBreaksFormWindow',
        method: 'POST',
        autoScroll:true,
        defaults: {
            labelAlign: 'top',
            autoScroll:true,
            width: 256
        },
        standardSubmit: false,
        plugins:"formlabelrequired",
        items: [{  
        	    xtype: 'hidden',
                name: 'id'
            },{
        	xtype: 'customcombobox',
            name: 'programPeriodSequence',
            itemId:'programPeriodSequence_Id',
            fieldLabel:getCommonTranslation('PROGRAM_PERIOD_SEQUENCE'),
//			translationKey: 'PROGRAM_PERIOD_SEQUENCE',
            store:'program.programDetails.programBatches.programPeriodBreak.PeriodBreakSequence',
            displayField:'value',
            valueField:'id',
            allowBlank: false
        },
        {
            xtype: 'textfield',
            name: 'periodName',
            fieldLabel: getCommonTranslation('PROGRAM_PERIOD_NAME'),
//			translationKey: 'PROGRAM_PERIOD_NAME',
            readOnly:true
        },
        {
            xtype: 'textfield',
            name: 'programPeriodBreakSeq',
            fieldLabel:getCommonTranslation('PROGRAM_BREAK_SEQUENCE'),
//			translationKey: 'PROGRAM_BREAK_SEQUENCE',
            readOnly:true,
            minValue:0
        },{
            xtype: 'textfield',
            name: 'breakName',
            fieldLabel: getCommonTranslation('PROGRAM_BREAK_NAME'),
//			translationKey: 'PROGRAM_BREAK_NAME',
            allowBlank: false,
            maxLength:20,
            vtype:'spaceAndSpecialCharactersAsInput'
        },{
        	xtype: 'datefield',
            anchor: '100%',
            fieldLabel: getCommonTranslation('PROGRAM_BREAK_START'),
//			translationKey: 'PROGRAM_BREAK_START',
            name: 'breakStart',
            itemId:'breakStart',
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            vtype: 'daterange',
            allowBlank: false,
            endDateField:'breakEnd',
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            }
        },{
        	xtype: 'datefield',
            anchor: '100%',
            fieldLabel: getCommonTranslation('PROGRAM_BREAK_END'),
//			translationKey: 'PROGRAM_BREAK_END',
            name: 'breakEnd',
            itemId:'breakEnd',
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.DATE_FORMAT,
            vtype: 'daterange',
            allowBlank: false,
            startDateField:'breakStart'
        },{
        	xtype: 'customcombobox',
	        name: 'breakType',
	        fieldLabel: getCommonTranslation('PROGRAM_BREAK_TYPE'),
//			translationKey: 'PROGRAM_BREAK_TYPE',
	        store:'program.programDetails.programBatches.programPeriodBreak.ProgramPeriodBreakType',
	        displayField:'value',
	        valueField:'id',
	        allowBlank: false
        },{
			xtype:'fieldcontainer',
//			width:'100%',
			cls:'windowBtnPos',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'programPeriodsBreaksFormSubmit',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'programPeriodsBreaksFormCancel',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }]
});