Ext.define('Academia.view.program.programDetails.programBatchDetails.periodsBreaks.ProgramPeriodsBreaksGrid', {
   // extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.programperiodsbreaksgrid',
    store : 'program.programDetails.programBatches.programPeriodBreak.ProgramPeriodBreakGrid',
    title : getCommonTranslation('PERIODS_BREAKS'),
    border: true,
    id:'programPeriodsBreakGridId',
    viewConfig : {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    dockedItems : [ {
    	xtype : 'toolbar',
    	dock : 'bottom',
    	items : [ {
    		xtype: 'custompagingtoolbar',
    		plugins:['pagesize'],
    		store : 'program.programDetails.programBatches.programPeriodBreak.ProgramPeriodBreakGrid',
    		emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
    		displayInfo : true
    	} ]
    }],
    initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
    },
    tbar: [{
    	xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    },{
		xtype : 'button',				
		itemId : 'btnEdit',
		tooltip : getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype : 'button',				
		itemId : 'btnView',
		tooltip : getCommonTranslation('VIEW'),//View department
		iconCls: 'view-icon'
	},{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
    columns : [ {
	    header : getCommonTranslation('PERIOD_SEQUENCE'),
	    dataIndex : 'periodSeq',
	    flex : .2,
	    sortable : true/*,
	    renderer:function(value){
	    	if(value!=null){
	    		return value.value; 
	    	}else{
	    		return value;
	    	}
	    }*/
	}, {
	    header : getCommonTranslation('PERIOD_BREAK_SEQUENCE'),
	    dataIndex : 'programPeriodBreakSeq',
	    flex : .2,
	    sortable : true
	}, {
	    header : getCommonTranslation('PERIOD_BREAK_START'),
	    dataIndex : 'breakStart',
	    flex : .2,
	    sortable : true,
	    renderer: function(date) {
            return dateRender(date);
        }
	},{
	    header : getCommonTranslation('PERIOD_BREAK_END'),
	    dataIndex : 'breakEnd',
	    flex : .2,
	    sortable : true,
	    renderer: function(date) {
            return dateRender(date);
        }
	},{
	    header : getCommonTranslation('BREAK_NAME'),
	    dataIndex : 'breakName',
	    flex : .2,
	    sortable : true
	}, {
	    header : getCommonTranslation('BREAK_TYPE'),
	    dataIndex : 'breakType',
	    flex : .2,
	    renderer:function(value){
	    	if(value == getCommonTranslation('HOLIDAY_BREAK')){
	    		return getCommonTranslation('HOLIDAY_TYPE');
	    	}else if(value == getCommonTranslation('WORKING_BREAK')){
	    		return getCommonTranslation('WORKING_TYPE');
	    	}
	    }
	}]
});
 