/*
 *  Dharmendra.P
 */

Ext.define('Academia.view.program.programDetails.programBatchDetails.seatTypes.ProgramBatchSeatTypeForm', {
	extend: 'Ext.window.Window',
	alias: 'widget.programbatchseattypewindow',
	modal: true,
	title: getCommonTranslation('SEAT_TYPE_FORM'),
	margin: 0,
	items: [{
		xtype: 'idgeneratorformwin',
		customFieldEntity:CONSTANTS.PROG_BATCH_SEAT_CONFIG,
		columns: 1,
		id:'programbatchseattype_Id',
		margin: 0,
		bodyPadding: '10 10 10 10',
		standardSubmit: false,
		plugins:"formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256
		},
		items: [{
			xtype : 'hidden',
			name : 'id'
		},{
			xtype : 'hidden',
			name : 'processStageId'
		},{
			xtype : 'hidden',
			name : 'batchOfSucceedingProgram'
		},{
			xtype : 'hidden',
			name : 'retainBatch'
		},{
			xtype : 'hidden',
			name : 'version'
		},{
			xtype: 'customcombobox',
			name:'seatType',
			fieldLabel : getCommonTranslation('SEAT_TYPE'),
			store:'program.programDetails.programBatches.programSeatType.ProgramBatchSeatTypeStore', 
			valueField : 'id',
			displayField : 'value',
			queryParam:'qry',
			minChars:3,
			queryMode:'local',
			typeAhead : true,
			forceSelection : true,
			allowBlank:false,
			anyMatch : true
		}, {
			xtype : 'numberfield',
			name : 'seatCapacity',
			itemId:'seatCapacity_Id',
			fieldLabel : getCommonTranslation('SEAT_CAPACITY'),
			minValue : 1,
			mouseWheelEnabled :false,
			hideTrigger :true,
			allowExponential:false,
			allowDecimals:false,
			allowBlank : false
		} ,{
			xtype: 'customcombobox',
			name:'succeedingSeatType',
			itemId:'succeedingSeatType',
			fieldLabel : getProgramandcourseTranslation('SUCCEEDING_SEAT_TYPE'),
			store:'program.programDetails.programBatches.programSeatType.SucceedingSeatType', 
			valueField : 'id',
			displayField : 'value',
			typeAhead :true,
			allowBlank:false
			//disabled:true
		},{
			xtype: 'customcombobox',
			name:'retainingSeatType',
			itemId:'retainingSeatType',
			fieldLabel : getProgramandcourseTranslation('RETAINING_SEAT_TYPE'),
			store:'program.programDetails.programBatches.programSeatType.RetainingSeatType', 
			valueField : 'id',
			displayField : 'value',
			typeAhead :true,
			allowBlank:false
			//disabled:true
		},{
			xtype: 'textfield',
			name:'processStage',
			readOnly:true,
			hidden:true,
			fieldLabel : getCommonTranslation('SELECTION_PROCESS')
		},{
			xtype:'checkbox',
			itemId : 'whetherEnableEnquiry',
			name:'whetherEnableEnquiry',
			//style:{'margin-left':'10px'},
			boxLabel:getCommonTranslation('WHETHER_ENQUIRY_ENABLE'),
			inputValue: true,
			uncheckedValue: false
		},{
			xtype:'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'saveButtonId',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel', 
				itemId: 'cancelButtonId',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});