/**
 * @ Ravi Choudhary
 */
Ext.define('Academia.view.program.programDetails.programBatches.ProgramBatchesForm',{
	extend:'Academia.view.common.IdGeneratorCustomForm',
	customFieldEntity:CONSTANTS.BATCH_CF_DATA,
	columns:3,
	formCode:'batchForm',
	alias : 'widget.programbatchesform',
	modal : true,
	autoScroll: true,
	layout:'anchor',
	cls:'horizontalScrollingFixed x-form-fixed-footer-parent',
	style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
	frame:true,
	title : getCommonTranslation('ADD_DETAILS'),
	itemId:'programbatchformid',
	method : 'POST',
	layout : {
		type : 'vbox'
	},
	standardSubmit : false,
	defaults : {
		labelAlign : 'top',
		width: 256
	},
	plugins : "formlabelrequired",
	items : [{
		xtype : 'fieldcontainer',
		itemId : 'inherit_pro_Id',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'hidden',
			name : 'id'
		},{
			xtype : 'hidden',
			name : 'version'
		},{
			xtype : 'hidden',
			name : 'specPossible'
		},{
			xtype : 'textfield',
			name : 'name',
			itemId : 'batch_Id',
			fieldLabel : getCommonTranslation('BATCH'),
			emptyText: getCommonTranslation('ID_AUTOGENERATE')
		},{
			xtype: 'textfield',
			name: 'printName',
			itemId:'printNameItemId',
			fieldLabel: getCourseTxCommonTranslation('PRINT_NAME'),
			allowBlank : false,
			
			
		},{
			xtype : 'customcombobox',
			name : 'intakeYear',
			itemId : 'intakeYear',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			store : Ext.create('Academia.store.common.IntakeYearWithQueryParamStore'),
			valueField : 'id',
			displayField : 'value',
    		queryMode:'local',
			typeAhead : true,
			forceSelection : true,
			allowBlank:false,
			anyMatch : true
			/*listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearWithQueryParamStore');
					combo.bindStore(store)
				}
			}*/
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'numberfield',
			name : 'seatCapacity',
			fieldLabel : getCommonTranslation('SEAT_CAPACITY'),
			minValue : 0,
			maxValue : 10000,
			mouseWheelEnabled :false,
			hideTrigger :true,
			allowExponential:false,
			allowDecimals:false,
			allowBlank:false
		},{
			xtype : 'customcombobox',
			name : 'programPeriodType',
			fieldLabel : getCommonTranslation('PROGRAM_PERIOD_TYPE'),
			store : 'program.programDetails.programBatches.ProgramPeriodTypeStore',
			valueField : 'id',
			displayField : 'value',
			editable : false,
			allowBlank : false
		},{
			xtype : 'datefield',
			anchor : '100%',
			fieldLabel : getCommonTranslation('START_DATE'),
			name : 'startDate',
			itemId : 'startDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			vtype : 'daterange',
			allowBlank:false
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'datefield',
			anchor : '100%',
			fieldLabel : getCommonTranslation('END_DATE'),
			name : 'tillDate',
			itemId : 'tillDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			vtype : 'daterange',
			allowBlank:false
		 },{
			xtype : 'numberfield',
			name : 'minPeriod',
			fieldLabel : getCommonTranslation('MIN_PERIOD'),
			itemId : 'min_Period_Id',
			itemId : 'minPeriodBatchForm_Id',
			minValue : 0,
			maxValue:999,
			mouseWheelEnabled :false,
			hideTrigger :true,
			allowBlank:false,
			allowExponential:false,
			allowDecimals:false,
			validator : function(val) {
				var maxValuefield = Ext.ComponentQuery.query('numberfield#maxperiodBatchForm_Id')[0];
				var maxValue = maxValuefield.getValue();
				if (maxValue != null) {
					if (val <= maxValue) {
						maxValuefield.clearInvalid();
						return true;
					} else {
						return 'Less than max period';
					}
				} else {
					return true;
				}
			}
		},{
			xtype : 'numberfield',
			name : 'maxPeriod',
			itemId : 'maxperiodBatchForm_Id',
			fieldLabel : getCommonTranslation('MAX_PERIOD'),
			minValue : 0,
			maxValue:999,
			mouseWheelEnabled :false,
			hideTrigger :true,
			allowExponential:false,
			allowDecimals:false,
			allowBlank:false,
			validator : function(val) {
				var minValueField = Ext.ComponentQuery
				.query('numberfield#minPeriodBatchForm_Id')[0];
				var minValue = minValueField
				.getValue();
				if (minValue != null) {
					if (val >= minValue) {
						minValueField
						.clearInvalid();
						return true;
					} else {
						return 'More than min period';
					}

				} else {
					return true;
				}
			}
		},
		{
			xtype : 'customcombobox',
			name : 'batchOfSucceedingProgram',
			fieldLabel : getProgramandcourseTranslation('SUCCEEDING_BATCH'),
			store : 'program.programDetails.programBatches.SucceedingBatches',
			valueField : 'id',
			displayField : 'value',
			hidden:true,
			editable : false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},
		]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'radiogroup',
			fieldLabel : getCommonTranslation('Is Retention Applicable'),
			itemId : 'isRetentionApplicable_Id',
			name : 'isRetentionApplicableId',
			 defaults: {
        		 flex: 1
        	 },
        	 layout: 'hbox',
			items : [{
				boxLabel : getCommonTranslation('YES'),
				name : 'isRetentionApplicable',
				inputValue : true
			},{
				boxLabel : getCommonTranslation('NO'),
				name : 'isRetentionApplicable',
				inputValue : false,
				checked : true

			}]
		},{
			xtype : 'customcombobox',
			name : 'retainBatch',
			itemId : 'retainingBatch_Id',
			fieldLabel : getProgramandcourseTranslation('RETAINING_BATCH'),
			store : 'program.programDetails.programBatches.RetainingBatches',
			valueField : 'id',
			displayField : 'value',
			allowBlank : true,
			forceSelection:true,
			typeAhead:false
		},{			
			xtype : 'numberfield',
			name : 'completionTime',
			fieldLabel : getCommonTranslation('COMPLETION_TIME'),
			itemId : 'completionTime',
			minValue : 0,
			maxValue:99,
			mouseWheelEnabled :false,
			hideTrigger :true,
			allowBlank:true,
			allowExponential:false,
			allowDecimals:false,
		},{
			xtype: 'multiselectcombofield',
			name: 'holdSubCategory',
			itemId: 'holdSubCategory',
			fieldLabel : getCommonTranslation('HOLD_SUB_CATEGORY'),
			displayField:'value',
			valueField:'id',
			queryMode:'local',
			cls:'commonAutoHeightMultiselectField',
			store: Ext.create('Academia.store.program.programbatchdetail.ApplyHoldStore'),
			autoloadStore: false,
			},
			{
			xtype: 'textfield',
			name: 'programBatchPrefix',
			itemId:'programPatchPrefixItemId',
			fieldLabel: getProgramandcourseTranslation('BATCH_PREFIX'),
			hidden:true,
			maxLength: 100,
			//allowBlank : false,
		    },{
			xtype: 'numberfield',
			name: 'programBatchSeq',
			itemId:'programBatchSequenceItemId',
			fieldLabel: getProgramandcourseTranslation('BATCH_SEQUENCE'),
			hidden:true,
			readOnly:true,
			minValue : 0,
			maxLength: 100,
			//allowBlank : false,
			},
			]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'radiogroup',
			fieldLabel : getCommonTranslation('ADDITIONAL_REQUIREMENT'),
			itemId : 'additionlReq_Id',
			 defaults: {
        		 flex: 1
        	 },
        	 layout: 'hbox',
			items : [{
				boxLabel : getCommonTranslation('YES'),
				name : 'hasAdditionalRequirement',
				inputValue : true
			},{
				boxLabel : getCommonTranslation('NO'),
				name : 'hasAdditionalRequirement',
				inputValue : false,
				checked : true
			}]
		},{
			xtype : 'radiogroup',
			fieldLabel : getCommonTranslation('SPECIALIZATION_POSSIBLE'),
			itemId : 'specializationPossible_itemId',
			defaults: {
       		 flex: 1
       	    },
       	    layout: 'hbox',
			items : [{
				boxLabel : getCommonTranslation('YES'),
				name : 'specializationPossible',
				inputValue : true,
				checked : true
			},{
				boxLabel : getCommonTranslation('NO'),
				name : 'specializationPossible',
				inputValue : false
			}]
		},{
          	xtype: 'customcombobox',
            name: 'modeOfDelivery',
            itemId: 'modeOfDeliveryId',
            fieldLabel: getCommonTranslation('MODE_OF_DELIVERY'),
            store:Ext.create('Academia.store.common.ModeOfDeliveryStore'),
            displayField:'value',
            valueField:'id',
            allowBlank : true,
            editable : false
        }
        ]
	},{
		xtype : 'textarea',
		align : 'left',
		width: 536,
		fieldLabel : getCommonTranslation('ADDITIONAL_REQUIREMENT_DETAILS'),
		name : 'additionalRequirementDetails',
		itemId : 'additionalRequirement_Id',
		allowBlank : false,
		hidden:true
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{ 
    			xtype: 'multiselectcombofield',
    			name: 'classification',
    			itemId: 'classification',
    			fieldLabel : getCommonTranslation('CLASSIFICATION'),
    			displayField:'value',
    			valueField:'id', 
    			maxLength:15000,
    			autoloadStore: false,
				hidden:true,
    			queryMode:'local',
				cls:'commonAutoHeightMultiselectField',
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.width = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}' +
    					'</div>';
    				}
    			},
            	listeners  :{
            		render : function(combo){
            			var store=Ext.create('Academia.store.common.StudentClassificationStore');
            			combo.bindStore(store);
            			store.load();
            		}
            	}
		},{
    			xtype: 'multiselectcombofield',
    			name: 'specialization',
    			itemId: 'specialization',
    			fieldLabel : getCommonTranslation('SPECIALIZATION'),
    			displayField:'value',
    			valueField:'id', 
    			maxLength:15000,
    			autoloadStore: false,
				hidden:true,
    			queryMode:'local',
				cls:'commonAutoHeightMultiselectField',
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.width = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}' +
    					'</div>';
    				}
    			},
            	listeners  :{
            		render : function(combo){
            			var store=Ext.create('Academia.store.common.StudentSpecializationStore');
            			combo.bindStore(store);
            			store.load();
            		}
            	}
		},{
				xtype: 'multiselectcombofield',
    			name: 'awardType',
    			itemId: 'awardType',
    			fieldLabel : getCommonTranslation('AWARD_TYPE'),
    			displayField:'value',
    			valueField:'id', 
    			maxLength:15000,
    			autoloadStore: false,
				hidden:true,
    			//queryMode:'local',
				cls:'commonAutoHeightMultiselectField',
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.width = picker.up('combobox').getSize().width;
							
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{code}' +
    					'</div>';
    				}
    			},
            	listeners  :{
            		render : function(combo){
            			var store=Ext.create('Academia.store.common.ProgramCompletionAwardTypeStore');
            			combo.bindStore(store);
            			store.load();
            		}
            	}
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		style : {
			margin: '1px'
		},
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
		xtype : 'radiogroup',
		fieldLabel : getCourseTxCommonTranslation('ADVANCE_CONFIGURATION_REQUIRED'),
		itemId : 'isAdvanceConfigId',
		defaults: {
			flex: 1
		},
		layout: 'hbox',
		items : [{
			
			boxLabel : getCommonTranslation('YES'),
			name : 'isAdvanceConfig',
			inputValue : true,
			checked : true
		},{
			boxLabel : getCommonTranslation('NO'),
			name : 'isAdvanceConfig',
			inputValue : false,
		}]
	},{
		xtype: 'textfield',
		name: 'estimatedFees',
		itemId:'estimatedFees',
		fieldLabel: getProgramandcourseTranslation('ESTIMATED_FEES'),
		maxLength : 255	
	},{
		xtype: 'radiogroup',
		fieldLabel: getCommonTranslation('COURSE_FEE_APPLICABLE'),
		itemId: 'isFeeApplicable',
		name: 'isFeeApplicable',
		defaults: {
			flex: 1
		},
		layout: 'hbox',
		items:[{ 
			boxLabel: getCommonTranslation('YES'),
			name:'isFeeApplicable',
			inputValue: true 
		},{ 
			boxLabel: getCommonTranslation('NO'), 
			name:'isFeeApplicable',
			inputValue: false,
			checked:true
		}]
	}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [
	        {
				xtype : 'numberfield',
				name : 'usCredits',
				fieldLabel : getProgramandcourseTranslation('US_CREDITS'),
				itemId : 'usCredits',
				minValue : 0,
				maxValue : 999,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowBlank:true,
				hidden:true,
				allowDecimals:true,
				decimalPrecision: 2
				
			},
			{
				xtype : 'numberfield',
				name : 'ectsCredits',
				fieldLabel : getProgramandcourseTranslation('ECTS_CREDITS'),
				itemId : 'ectsCredits',
				minValue : 0,
				maxValue : 999,
				mouseWheelEnabled :false,
				hideTrigger :true,
				allowBlank:true,
				hidden:true,
				allowDecimals:true,
				decimalPrecision: 2
			}
		          ]
	}
	,{
		xtype : 'fieldcontainer',
		itemId:'graduationSettingContId',
		width : '100%',
		layout : {
			type : 'vbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		fieldLabel : '<b class="menu-title">'+getCourseTxCommonTranslation('GRADUATION_SETTINGS')+'</b>',
		 style: {
			 textDecoration: "underline"
		 },
		items : [{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'numberfield',
			name : 'minProgramCredits',
			fieldLabel : getCommonTranslation('MINIMUM_CREDIT'),
			itemId : 'minProgramCreditsBatchForm_ItemId',
			minValue : 0,
			maxValue:999,
			allowBlank:false,
			mouseWheelEnabled :false,
			hideTrigger :true,
			allowExponential:false,
			allowDecimals:true,
			decimalPrecision: 2,
			validator : function(val) {
				var maxValuefield = Ext.ComponentQuery
				.query('numberfield#maxProgramCreditsBatchForm_ItemId')[0];
				var maxValue = maxValuefield
				.getValue();
				if (maxValue != null) {
					if (val <= maxValue) {
						maxValuefield
						.clearInvalid();
						return true;
					} else {
						return 'Less than max credit';
					}
				} else {
					return true;
				}
			}
		},{
			xtype : 'numberfield',
			name : 'maxProgramCredits',
			fieldLabel : getCommonTranslation('MAXIMUM_CREDIT'),
			itemId : 'maxProgramCreditsBatchForm_ItemId',
			minValue : 0,
			maxValue:1100,
			mouseWheelEnabled :false,
			hideTrigger :true,
			allowBlank:false,
			allowExponential:false,
			allowDecimals:true,
			decimalPrecision: 2,
			validator : function(val) {
				var minValueField = Ext.ComponentQuery
				.query('numberfield#minProgramCreditsBatchForm_ItemId')[0];
				var minValue = minValueField
				.getValue();
				if (minValue != null) {
					if (val >= minValue) {
						minValueField
						.clearInvalid();
						return true;
					} else {
						return 'More than min credit';
					}

				} else {
					return true;
				}
			}
		}]
	},
	{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [
		         {
		        	 xtype : 'numberfield',
		        	 name : 'minProgramCourses',
		        	 fieldLabel : getCommonTranslation('MIN_COURSES'),
		        	 itemId : 'minProgramCoursesBatchForm_ItemId',
		        	 minValue : 0,
		        	 maxValue:999,
		        	 mouseWheelEnabled :false,
		        	 hideTrigger :true,
		        	 allowBlank:false,
		        	 allowExponential:false,
		        	 allowDecimals:false,
		        	 validator : function(val) {
		        		 var maxValuefield = Ext.ComponentQuery
		        		 .query('numberfield#maxProgramCoursesBatchForm_ItemId')[0];
		        		 var maxValue = maxValuefield
		        		 .getValue();
		        		 if (maxValue != null) {
		        			 if (val <= maxValue) {
		        				 maxValuefield
		        				 .clearInvalid();
		        				 return true;
		        			 } else {
		        				 return 'Less than max courses';
		        			 }
		        		 } else {
		        			 return true;
		        		 }
		        	 }
		         },
		         {
		        	 xtype : 'numberfield',
		        	 name : 'maxProgramCourses',
		        	 fieldLabel : getCommonTranslation('MAX_COURSES'),
		        	 itemId : 'maxProgramCoursesBatchForm_ItemId',
		        	 minValue : 0,
		        	 maxValue:1100,
		        	 mouseWheelEnabled :false,
		        	 hideTrigger :true,
		        	 allowBlank:false,
		        	 allowExponential:false,
		        	 allowDecimals:false,
		        	 validator : function(val) {
		        		 var minValueField = Ext.ComponentQuery
		        		 .query('numberfield#minProgramCoursesBatchForm_ItemId')[0];
		        		 var minValue = minValueField
		        		 .getValue();
		        		 if (minValue != null) {
		        			 if (val >= minValue) {
		        				 minValueField
		        				 .clearInvalid();
		        				 return true;
		        			 } else {
		        				 return 'More than min courses';
		        			 }

		        		 } else {
		        			 return true;
		        		 }
		        	 }
		         } ]
	},
	{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [
		         {
		        	 xtype : 'numberfield',
		        	 name : 'minCompulsoryCourses',
		        	 fieldLabel : getCommonTranslation('MIN_MANDATORY_COURSES'),
		        	 itemId : 'minCompulsoryCoursesBatchForm_ItemId',
		        	 minValue : 0,
		        	 maxValue:999,
		        	 mouseWheelEnabled :false,
		        	 hideTrigger :true,
		        	 allowBlank:false,
		        	 allowExponential:false,
		        	 allowDecimals:false,
		        	 validator : function(val) {
		        		 var maxValuefield = Ext.ComponentQuery.query('numberfield#maxCompulsoryCoursesBatchForm_ItemId')[0];
		        		 var maxValue = maxValuefield.getValue();
		        		 
		        		 var mainCourseValuefield = Ext.ComponentQuery.query('numberfield#minProgramCoursesBatchForm_ItemId')[0];
		        		 var mainCourseValue = mainCourseValuefield.getValue();

		        		 var mainCourseValuefield = Ext.ComponentQuery.query('numberfield#minProgramCoursesBatchForm_ItemId')[0];
		        		 var mainCourseValue = mainCourseValuefield.getValue();
		        		 
		        		 if (mainCourseValue != null && mainCourseValue !=null) {
		        			 if (val <= mainCourseValue || val <= mainCourseValue) {
		        				 mainCourseValuefield.clearInvalid();
		        				 return true;
		        			 } else {
		        				 return 'Less than min courses and max compulsory courses';
		        			 }
		        			 
		        		 } 
		        		 
		        		 /*else {
		        			 return true;
		        		 }*/
		        	 }
		         },
		         {
		        	 xtype : 'numberfield',
		        	 name : 'maxCompulsoryCourses',
		        	 fieldLabel : getCommonTranslation('MAX_MANDATORY_COURSES'),
		        	 itemId : 'maxCompulsoryCoursesBatchForm_ItemId',
		        	 minValue : 0,
		        	 maxValue:1100,
		        	 mouseWheelEnabled :false,
		        	 hideTrigger :true,
		        	 allowExponential:false,
		        	 allowDecimals:false,
		        	 allowBlank:false,
		        	 validator : function(val) {
		        		 var minValueField = Ext.ComponentQuery.query('numberfield#minCompulsoryCoursesBatchForm_ItemId')[0];
		        		 var minValue = minValueField.getValue();
		        		 
		        		 var maxValueField = Ext.ComponentQuery.query('numberfield#maxProgramCoursesBatchForm_ItemId')[0];
		        		 var maxValue = maxValueField.getValue();
		        		 
		        		 var maxCumpField = Ext.ComponentQuery.query('numberfield#maxCompulsoryCoursesBatchForm_ItemId')[0];
		        		 if (maxValue != null) {
		        			 if (val > maxValue || val < minValue) {
		        				 return 'Less than max courses and more than min compulsory courses';
		        			 } else {
		        				 maxCumpField.clearInvalid();
		        				 return true;
		        			 }

		        		 } 
		        	 }
		         } ]
	},
	{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [
		         {
		        	 xtype : 'numberfield',
		        	 name : 'minOptionalCourses',
		        	 fieldLabel : getCommonTranslation('OPTIONAL_MIN_COURSES'),
		        	 itemId : 'minOptionalCoursesBatchForm_ItemId',
		        	 minValue : 0,
		        	 maxValue:999,
		        	 mouseWheelEnabled :false,
		        	 hideTrigger :true,
		        	 allowExponential:false,
		        	 allowDecimals:false,
		        	 allowBlank:false,
		        	 validator : function(val) {
		        		 var maxValuefield = Ext.ComponentQuery.query('numberfield#maxOptionalCoursesBatchForm_ItemId')[0];
		        		 var maxValue = maxValuefield.getValue();

		        		 var mainCourseValuefield = Ext.ComponentQuery.query('numberfield#minProgramCoursesBatchForm_ItemId')[0];
		        		 var mainCourseValue = mainCourseValuefield.getValue();
		        		 
		        		 if (mainCourseValue != null) {
		        			 if (val <= mainCourseValue) {
		        				 maxValuefield.clearInvalid();
		        				 return true;
		        			 } else {
		        				 return 'Less than min courses and max optional courses';
		        			 }
		        			 
		        		 }
		        	 }
		         },
		         {
		        	 xtype : 'numberfield',
		        	 name : 'maxOptionalCourses',
		        	 fieldLabel : getCommonTranslation('OPTIONAL_MAX_COURSES'),
		        	 itemId : 'maxOptionalCoursesBatchForm_ItemId',
		        	 minValue : 0,
		        	 maxValue:1100,
		        	 mouseWheelEnabled :false,
		        	 hideTrigger :true,
		        	 allowExponential:false,
		        	 allowBlank:false,
		        	 allowDecimals:false,
		        	 validator : function(val) {
		        		 var minValueField = Ext.ComponentQuery.query('numberfield#minOptionalCoursesBatchForm_ItemId')[0];
		        		 var minValue = minValueField.getValue();
		        		 
		        		 var maxValueField = Ext.ComponentQuery.query('numberfield#maxProgramCoursesBatchForm_ItemId')[0];
		        		 var maxValue = maxValueField.getValue();
		        		 var maxOpField = Ext.ComponentQuery.query('numberfield#maxOptionalCoursesBatchForm_ItemId')[0];
		        		 if (minValue != null) {
		        			 if (val > maxValue || val < minValue) {
		        				 return 'Less than max courses and more than min optional courses';

		        			 } else {
		        				 maxOpField.clearInvalid();
		        				 return true;
		        				 
		        			 }

		        		 }
		        	 }
		         } ]
	},
	{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			store:'examinationcenters.evaluation.RoundingModeForLevelOne',
			name: 'roundingMode',
			itemId:'roundingModeId',
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:true,
			hidden:false,
			fieldLabel:getExaminationTranslation('ROUNDING_MODE'),
			allowBlank: false
		},{
			xtype: 'numberfield',
			name: 'roundingCount',
			itemId:'roundingCountId',
			minValue:0,
			maxValue:4,
			allowBlank: false,
			fieldLabel: getExaminationTranslation('ROUNDING_POINT')
		}]
	}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'numberfield',
			name : 'cgpaRequired',
			itemId: 'cgpaRequired',
			fieldLabel : getProgramandcourseTranslation('CGPA_REQUIRED'),
			minValue:0,
			maxValue:10,
			mouseWheelEnabled :false,
			allowDecimals:true,
			decimalPrecision: 2,
			allowBlank:false,
			hideTrigger :true,
			allowExponential:false
		},{
			xtype : 'customcombobox',
			name : 'calendar',
			itemId: 'calendar',
			fieldLabel : getCommonTranslation('ASSIGN_CALENDER'),
			store : 'facilitiesresources.resourcemaster.MappedCalenderStore',
			displayField : 'value',
			valueField : 'id',
			allowBlank : false,
			editable : false
		},{
       	 xtype: 'customcombobox',
         name: 'sgpaCgpaCalculationRule',
         fieldLabel: getProgramandcourseTranslation('SGPA_CGPA_CALCULATION_RULE'),
         value:'Generic Rule',
         store: 'common.SGPACGPACalculationRuleStore',
         itemId: 'sgpaCgpaCalculationRuleItemId',
         valueField: 'value',
         displayField: 'name',
         allowBlank : false,
         editable : false,
    },
    {
		xtype:'numberfield',
		fieldLabel: getProgramandcourseTranslation('MINIMUM_CPA'),
		name:'minimumCPA',
		itemId:'minimumCPA',
		hidden:true,
		hideTrigger: true,
		//keyNavEnabled: false,
		mouseWheelEnabled: false,
		allowExponential:true,
		decimalPrecision: 6,
		format: '0.00',
		minValue:0,
		maxValue:99.99,
		listeners: {
		    change: function(field, newValue, oldValue, eOpts) {
		        // Truncate the number to two decimal places without rounding
		        var truncatedValue = Math.floor(newValue * 100) / 100;
		        field.setValue(truncatedValue.toFixed(2)); // Set the truncated value back to the field with 2 decimal places
		    }
		}
	},]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'customcombobox',
			name:'entryDrools',
			itemId:'entryDroolItemId',
			fieldLabel:getCommonTranslation('PROGRAM_ENTER_CRITERIA'),
			valueField: 'id',
			displayField: 'value',
			allowBlank: true,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			editable: false
		},{

			xtype: 'customcombobox',
			name:'exitDrools',
			itemId:'exitDroolItemId',
			store:'examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData',
			fieldLabel:getCommonTranslation('PROGRAM_EXIT_CRITERIA'),
			valueField: 'id',
			displayField: 'value',
			allowBlank: true,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			editable: false
		},{

			xtype: 'customcombobox',
			name:'otherRuleApplicable',
			itemId:'otherRuleApplicableId',
			store:Ext.create('Academia.store.examinationcenters.evaluation.evaluationPlanHeirarchy.DroolCalculationData'),
			fieldLabel:getProgramandcourseTranslation('OTHER_RULE_APPLICABLE'),
			valueField: 'id',
			displayField: 'value',
			allowBlank: true,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			editable: false
		}]
	}, {
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
		        	 xtype : 'radiogroup',
		        	 fieldLabel : getCommonTranslation('PLACEMENT_PROCESS_REQUIRED'),
		        	 itemId: 'placementProcessRequired',
		        	 defaults: {
		        		 flex: 1
		        	 },
		        	 layout: 'hbox',
		        	 items : [ {
		        		 boxLabel : getCommonTranslation('YES'),
		        		 name : 'placementProcessRequired',
		        		 inputValue : 'true',
		        		 checked : true
		        	 }, {
		        		 boxLabel :getCommonTranslation('NO'),
		        		 name : 'placementProcessRequired',
		        		 inputValue : 'false'
		        	 } ]
		         }, {
		        	 xtype : 'radiogroup',
		        	 fieldLabel : getCommonTranslation('PROGRAM_STATUS'),
		        	 itemId : 'batchPartTime',
		        	 name : 'batchPartTimeId',
		        	 defaults: {
		        		 flex: 1
		        	 },
		        	 layout: 'hbox',
		        	 items : [ {
		        		 boxLabel : getCommonTranslation('PART_TIME'),
		        		 name : 'batchPartTime',
		        		 inputValue : true

		        	 }, {
		        		 boxLabel :getCommonTranslation('FULL_TIME'),
		        		 name : 'batchPartTime',
		        		 inputValue : false,
		        		 checked : true
		        	 } ]
		         },{
		        	 xtype : 'radiogroup',
		        	 fieldLabel : getCommonTranslation('ENABLE_ENQUIRIES'),
		        	 itemId : 'enquiryEnable_Id',
		 			 name : 'enquiryEnableId',
		        	 defaults: {
		        		 flex: 1
		        	 },
		        	 layout: 'hbox',
		        	 items : [ {
		        		 boxLabel : getCommonTranslation('YES'),
		        		 name : 'enquiryEnable',
		        		 inputValue : true,
		        		 checked : true
		        	 }, {
		        		 boxLabel : getCommonTranslation('NO'),
		        		 name : 'enquiryEnable',
		        		 inputValue : false,
		        	 } ]
		         },{
		        	 xtype : 'radiogroup',
		        	 fieldLabel : getExaminationTranslation('INCLUDE_REPEATED_COURSES_IN_CGPA'),
		        	 itemId : 'isIncludeRepeatedCoursesInCGPA',
		        	 name : 'isIncludeRepeatedCoursesInCGPAId',
		        	 defaults: {
		        		 flex: 1
		        	 },
		        	 layout: 'hbox',
		        	 items : [ {
		        		 boxLabel : getCommonTranslation('YES'),
		        		 name : 'isIncludeRepeatedCoursesInCGPA',
		        		 inputValue : true,
		        	 }, {
		        		 boxLabel : getCommonTranslation('NO'),
		        		 name : 'isIncludeRepeatedCoursesInCGPA',
		        		 inputValue : false,
		        		 checked : true
		        	 } ]
		         }]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		itemId : 'isTransferCreditFromStudentPortalContainer',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
       	 xtype : 'radiogroup',
    	 fieldLabel : getProgramandcourseTranslation('TRNASFER_CREDIT_FROM_STUDENT_PORTAL'),
    	 itemId : 'isTransferCreditFromStudentPortalId',
    	 name : 'isTransferCreditFromStudentPortal',
    	 hidden:true,
    	 defaults: {
    		 flex: 1
    	 },
    	 layout: 'hbox',
    	 items : [ {
    		 boxLabel : getCommonTranslation('YES'),
    		 name : 'isTransferCreditFromStudentPortal',
    		 inputValue : true,
    	 }, {
    		 boxLabel : getCommonTranslation('NO'),
    		 name : 'isTransferCreditFromStudentPortal',
    		 inputValue : false,
    		 checked : true
    	 } ]
     },
     {  
			xtype: 'multiselectcombofield',
			width: 256,
			name: 'resultStatus',
			itemId: 'resultStatusRequiredId',
			allowBlank : false,
			editable:false,
			fieldLabel : getProgramandcourseTranslation('RESULT_STATUS_REQUIRED'),
			store:Ext.create('Academia.store.common.ResultStatusRequiredStore'),
			displayField:'value',
			valueField:'id',
			matchFieldWidth:true,
			maxLength:15000,
			//autoloadStore: false,
			//queryMode:'local',
			hidden:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		     },
		     {
		          	xtype: 'customcombobox',
		            name: 'creditType',
		            itemId: 'creditTypeId',
		            fieldLabel: getProgramandcourseTranslation('CREDIT_TYPE'),
		            store:Ext.create('Academia.store.coursetransaction.homework.CreditTypeDropDown'),
		            displayField:'value',
		            valueField:'id',
		            allowBlank : true,
		            editable : false,
		            hidden:true,
		        },
		        {
		        	 xtype : 'radiogroup',
		        	 fieldLabel : getProgramandcourseTranslation('EQUIVALENCE_CHECK'),
		        	 itemId : 'isEquivalenceCheckId',
		        	 name : 'isEquivalenceCheck',
		        	 hidden:true,
		        	 defaults: {
		        		 flex: 1
		        	 },
		        	 layout: 'hbox',
		        	 items : [ {
		        		 boxLabel : getCommonTranslation('YES'),
		        		 name : 'isEquivalenceCheck',
		        		 inputValue : true,
		        	 }, {
		        		 boxLabel : getCommonTranslation('NO'),
		        		 name : 'isEquivalenceCheck',
		        		 inputValue : false,
		        		 checked : true
		        	 } ]
		         }]
		
		},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
		    xtype:'checkbox',
		    name: 'showMappedCoursesforCreditTransfer',
		    boxLabel: getProgramandcourseTranslation('SHOW_MAPPED_COURSE_FOR_CREDIT_TRANSFER'),
		    itemId:'showMappedCoursesforCreditTransferId',
		    inputValue: true,
			uncheckedValue: false
		   }]
	    },{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
		    xtype:'checkbox',
		    name: 'allowMultipleLastPeriods',
		    boxLabel: getProgramandcourseTranslation('ALLOW_MULTIPLE_LAST_PERIODS'),
		    itemId:'allowMultipleLastPeriodsId',
		    inputValue: true,
			uncheckedValue: false
		   }]
	    },{
		xtype : 'fieldcontainer',
		width : '100%',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textarea',
			align : 'left',
			width: 536,
			maxLength: 40000,
			fieldLabel : getCommonTranslation('ELIGIBILITY_CRITERIA'),
			name : 'eligibilityCriteria',
			itemId : 'eligibilityCriteria_Id',
			allowBlank : true
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
		    xtype:'checkbox',
		    name: 'publishInCatalogue',
		    boxLabel: getProgramandcourseTranslation('PUBLISH_IN_CATALOGUE'),
		    itemId:'publishInCatalogueId',
		    inputValue: true,
			uncheckedValue: false,
		   }]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype:'programbatchdocumentgrid',
			margin: '5px 0px 0px 2px'
		}]
	},{
		xtype:'fieldcontainer',
		width:'100%',
		cls: 'form-fixed-footer',
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'programBatches_Add',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			name: 'programBatchDocument',
			text:getCommonTranslation('UPLOAD_DOC'),
			itemId: 'programBatchDocument',
			ui: 'CustomBtnThird',
			scale : CONSTANTS.BUTTONSIZE
		}]
	} ]
});