/**
 * @author Suraj Chouhan
 */
Ext.define('Academia.view.program.programDetails.programDownloadHesaData.programDownloadHesaDataWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.programdownloadhesadatawin',
	title: getCommonTranslation('DOWNLOAD_HESA_DATA'),
	frame: true,
	autoScroll:true,
	modal:true,
	items: [{
		xtype: 'form',
		itemId:'programdownloadhesadatawinId',
		method: 'POST',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width: 256,
		},
		standardSubmit: false,
		items: [{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype : 'customcombobox',
				width: 256,
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
				name : 'academicTerm',
				itemId : 'academicTerm',
				allowBlank : false,
				displayField : 'value',
				store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				valueField : 'id',
				editable : true,
	             typeAhead : false,
	             forceSelection : true,
	             anyMatch : true
			}]
		},{
			xtype:'fieldcontainer',
			style:{marginTop:'10px'},
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getCommonTranslation('GENERATE_XML'),
				formBind: true,
				itemId: 'SubmitBtnForGenerateXML',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtnHesaWin',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]
	}]
});