/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.program.reports.enrollmentSummaryReport.EnrollmentSummaryReportGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.enrollmentsummaryreportgrid',
    store: 'programCourseDashboard.EnrollmentSummaryReportStore',
    title: getCommonTranslation('ENROLLMENT_SUMMARY_REPORT'),
    border: true,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'exportReportsId',
        tooltip: getCommonTranslation('EXPORTREPORTS'),
        text: getCommonTranslation('EXPORTREPORTS'),
        formBind: true,
    }],
    columns: [{
        header: getProgramandcourseTranslation('COURSE_CODE'), 
        dataIndex: 'courseCode',
        flex: .1,
        sortable: true
    }, {
        header: getProgramandcourseTranslation('COURSE'),
        dataIndex: 'course',
        flex: .1,
        sortable: true
    }, {
        header: getProgramandcourseTranslation('COMPONENT'),
        dataIndex: 'courseComponent',
        flex: .1,
        sortable: true
    }, {
        header: getProgramandcourseTranslation('ESR_NO_OF_STUDENTS'),
        dataIndex: 'noOfStudents',
        flex: .1,
        sortable: true
    }, {
        header: getProgramandcourseTranslation('ESR_SEMESTER'),
        dataIndex: 'periodName',
        flex: .1,
        sortable: true
    }, {
        header: getProgramandcourseTranslation('PROGRAM_CATEGORY'),
        dataIndex: 'programCategory',
        flex: .1,
        hidden: true,
        sortable: true
    }, {
        header: getProgramandcourseTranslation('PROGRAM_NAME'),
        dataIndex: 'programName',
        flex: .1,
        hidden: true,
        sortable: true
    }]
});