/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.program.uploaddownload.CourseFacultyMappingCBSDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.coursefacultymappingcbsdownloadform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	items:[{
		xtype : 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign: 'top'
		},
		items : [{
			xtype: 'multiselectcombofield',
			name: 'batch',
			itemId: 'batchId',
			width: 536,
			fieldLabel: getProgramandcourseTranslation('PROGRAM_BATCH'),
			store : Ext.create("Academia.store.program.ProgramBatchesStore"),
			displayField : 'value',
			valueField : 'id',
			queryParam:'name',
			typeAhead : true,
			forceSelection:true,
			hideTrigger:false,
			triggerAction: 'all',
			minChars:3,
			autoloadStore:false,
			cls:'ProgramCourseMultiselectField',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		}
		]},{
		xtype : 'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign: 'top'
		},
		items : [{
			xtype : 'multiselectcombofield',
			name: 'courseId',
			itemId: 'courseItemId',
			fieldLabel:getCourseTxCommonTranslation('COURSE'),
			autoloadStore: false,
			width: 536,
			store : 'program.ProgramBatchCoursesByIdsStore',
			displayField : 'value',
			valueField : 'id',
			queryParam:'name',
			minChars:3,
			typeAhead:true,
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			cls:'ProgramCourseMultiselectField',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}'  +
					'</div>';
				}
			}
		},{
			xtype : 'multiselectcombofield',
			name: 'variant',
			itemId: 'variantId',
			fieldLabel : getCourseTxCommonTranslation('COURSE_VARIANT'),
			autoloadStore: false,
			width: 536,
			cls:'resetPasswordMultiselect',
			store:'course.coursevariants.CourseVariantByBatchAndCourseStrore',
			displayField : 'value',
			valueField : 'id',
			queryParam:'name',
			minChars:3,
			typeAhead:true,
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			hidden:false,
			disabled:true,
			cls:'ProgramCourseMultiselectField',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{componentTypeName}'  +
					'</div>';
				}
			}
		}]},{
			xtype : 'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			style:{
    			'margin-left':'-64px !important'
    		},
			items : [{
				xtype: 'fieldcontainer',
				width: 'auto',
				items: [{
					xtype: 'button',
					text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
					itemId: 'downoladBtnId',
					ui: 'CustomBtnSubmit'
				},{
					xtype: 'button',
					text: getCourseTxCommonTranslation('RESET'),
					itemId: 'resetBtn',
					buttonAlign: 'left',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE
				}]}
			]
		}]
});
