/**
 * @author Ranga
 * 
 */
Ext.define('Academia.view.program.uploaddownload.ProgramDownloadForm',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.programdownloadform',
	frame: false,
	method : 'POST',
	standardSubmit : false,
	//width:'auto',
	//height:'auto',
	items : [{
		xtype:'fieldcontainer',
		layout : 'hbox',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items: [{
    			xtype : 'customcombobox',
    			name : 'downloadType',
    			itemId:'downloadTypeItemId',
    			fieldLabel : getProgramandcourseTranslation('TEMPLATE_FOR'),	
    			store:'program.ProgramTemplateTypeStore',
    			valueField : 'id',
    			displayField : 'value',
    			triggerAction : 'all',
    			editable : false,
    			allowBlank : false
    		}, {
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
				name: 'academyLocationId',
				itemId:'academyLocationComboField',
				store: Ext.create('Academia.store.user.UserAcademyLocationStore'),
				displayField: 'value',
				valueField: 'id',
				typeAhead: false,
				forceSelection: true,
				triggerAction: 'all',
				editable: false,
				allowBlank: false,
				hidden: true
			}, {
        		xtype: 'customcombobox',
        		name: 'programGroupId',
        		itemId:'programGroupComboField',
        		fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
        		store:Ext.create('Academia.store.admission.applicationFormSale.ProgramGroupComboStore'),
        		editable: true,
        		valueField: 'id',
        		displayField: 'value',
        		forceSelection:true,
        		hidden: true,
    			allowBlank : false,
    			editable: false,
    			disabled: true
        	}]
		},{
			xtype:'fieldcontainer',
			layout : 'hbox',
			width: 'auto',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'programId',
				itemId: 'programCodeNameField',
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
				valueField: 'id',
				displayField: 'valueCode',
				minChars:3,
				allowBlank: true,
				forceSelection : true,
				queryParam:'programName',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				hidden: true,
				store: Ext.create('Academia.store.feeandpayment.reports.Program'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'batchId',
				itemId: 'batchField',
				fieldLabel: getPersonModuleTranslation('BATCH'),
				disabled:true,
				width: 256,
				displayField: 'value',
				valueField: 'id',
				store:'enquiry.AcademicBatchStore',
				editable:false,
				allowBlank: true,
				hidden: true
			}]
		},{

			xtype:'fieldcontainer',
			width: 'auto',
			//cls: 'form-fixed-footer',
    		layout: 'hbox',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
    		style:{
    			'margin-left':'-32px !important'
    		},
			items:[{
					xtype: 'button',
					text: getProgramandcourseTranslation('MARK_ATTENDANCE_DOWNLOAD'),
					itemId: 'downoladBtnId',
					hidden:false,
					disabled:true,
					ui: 'CustomBtnSubmit'
			}]
		
		}]
});
