/**
 * @author Akshay Sharma
 */
Ext.define('Academia.view.programCourseDashboard.CourseExecutionReportStructure', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.courseexecutionreportstructure',
	autoScroll: false,
	frame: false,
	autoScroll: false,
	frame: false,
	cls:'panelNoSpace',
	items: [{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{	
			xtype:'panel',
			width: '100%',
			cls:'panelNoSpace',
			items:[{
				xtype: 'radiogroup',
				itemId:'selectionTypeId',				
				columns: 2,
				vertical: false,				
				items: [
				        { boxLabel: getProgramandcourseTranslation('PROGRAM_BATCH_SECTION'), name: 'selectionType', inputValue: 'PROGRAM_BATCH_SECTION',checked:true},
				        { boxLabel: getProgramandcourseTranslation('COURSE_SECTION'), name: 'selectionType', inputValue: 'COURSE_SECTION'}
				        ]
			}]			
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width:'100%',
			defaults :{
				labelAlign:'top',
				width: 256
			},
			items: [{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),

				name : 'programId',
				itemId : 'programId',      	   
				store : 'common.AssignedProgramStore',
				displayField : 'code',
				valueField : 'id',
				//typeAhead : true,
				forceSelection : true,
				allowBlank : false,
				hidden : false,
				triggerAction: 'all',
				minChars:3,
				//queryMode:'local',
				queryParam:'name',
				    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    	            listConfig: {
  					  listeners: {
  							beforeshow: function(picker) {
  								picker.minWidth = picker.up('combobox').getSize().width;
  							}
  						},
  		                loadingText: getCommonTranslation('SEARCHING'),
  		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
  		                getInnerTpl: function() {
  		                    return '<div class="search-item">' +
  		                  '{code} / {value}'+
  		                    '</div>';
  		                }
  		            }
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('BATCH'),		

				name : 'batchId',
				itemId : 'batchId',
				store : 'enquiry.AcademicBatchStore',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : false,
				hidden : false
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
				store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
				name : 'academicTerm',
				itemId : 'academicTermId',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				editable:false,
				hidden : true
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
				name : 'courseIdCBS',	
				itemId : 'courseIdCBS',
				store : Ext.create('Academia.store.attendance.facultyportal.AttendanceCourses'),
				displayField : 'courseCodeName',
				valueField : 'courseId',
				queryParam:'name',
				//typeAhead : true,
				forceSelection : true,
				minChars:3,
				hidden : true,
				 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	                listConfig: {
	    				  listeners: {
	    						beforeshow: function(picker) {
	    							picker.minWidth = picker.up('combobox').getSize().width;
	    						}
	    					},
	    	                loadingText: getCommonTranslation('SEARCHING'),
	    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	    	                getInnerTpl: function() {
	    	                    return '<div class="search-item">' +
	    	                        '{value}' +
	    	                    '</div>';
	    	                }
	    	            }
			},{
				xtype: 'customcombobox',
				fieldLabel: getCourseTxCommonTranslation('COURSE_VARIANT'),
				name:'courseVariant',
				itemId: 'courseVariantId',
				store:Ext.create('Academia.store.attendance.facultyportal.AttendanceCourseVariantStore'),
				displayField: 'courseVariantCode',
				valueField: 'id',
				typeAhead:true,
				forceSelection:true,
				allowBlank:true,
				disabled:true,
				editable:false,
				hidden : true
			},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('PERIOD'),

				name : 'periodId',
				itemId : 'periodId',
				store : 'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField : 'value',
				valueField : 'id',
				typeAhead : true,
				forceSelection : true,
				allowBlank : false,
				hidden : false
			}]},{
				xtype:'fieldcontainer',
				layout:'hbox',
				width:'100%',
				defaults :{
					labelAlign:'top',
					width: 256
				},
				items: [{
					xtype : 'customcombobox',
					fieldLabel :getCommonTranslation('COURSE_CODE_NAME'),

					name : 'courseIdPBS',
					itemId : 'courseIdPBS',
					store : 'course.AssignedPeriodCoursesFacultyStore',
					displayField : 'courseCodeName',
					valueField : 'courseId',
					//typeAhead : true,
					minChars:3,
					queryParam:'name',
					forceSelection : true,
					allowBlank : false,
					hidden : false,
					 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		                listConfig: {
		    				  listeners: {
		    						beforeshow: function(picker) {
		    							picker.minWidth = picker.up('combobox').getSize().width;
		    						}
		    					},
		    	                loadingText: getCommonTranslation('SEARCHING'),
		    	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		    	                getInnerTpl: function() {
		    	                    return '<div class="search-item">' +
		    	                        '{value}' +
		    	                    '</div>';
		    	                }
		    	            }
				},{
					xtype : 'customcombobox',
					fieldLabel : getCourseTxCommonTranslation('SECTION'),
					name : 'programSectionId',
					itemId : 'programSectionId',
					store : 'coursetransaction.sectionmanagement.SectionsStore',
					displayField : 'value',
					valueField : 'id',
					typeAhead : true,
					forceSelection : true,
					allowBlank : false,
					hidden : false
				},/*{
					xtype: 'customcombobox',
					fieldLabel: getPersonModuleTranslation('EMPLOYEE_ID_OR_NAME'),
					name: 'facultyCodeItem',
					itemId:'facultyCodeItemId',
					store:'common.ActiveUserStore',
					valueField: 'id',
					displayField: 'valueCode',
					queryParam:'name',
					minChars:3,
					typeAhead:false,
					hideTrigger:true,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code} / {value}' +
							'</div>';
						}
					}
				}*/]
			},{
				xtype: 'fieldcontainer',
				width: '100%',
				cls: 'customSearchPanelBtnsFieldContainerCls',
				items: [{
					xtype: 'button',
					text: getCommonTranslation('SEARCH'),
					itemId: 'btnSearch',
					buttonAlign: 'left',
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE               
				},{
					xtype: 'button',
					text: getCommonTranslation('RESET'),
					itemId: 'btnReset',
					// buttonAlign: 'left',
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE   
				}]	
			}]
	},{
		xtype:'panel',
		items:[{
			xtype:'searchresultgrid',
			title :getProgramandcourseTranslation('DELAYED_COURSE'),
			width: '100%',
			itemId:'facultydelayedCourseSearchGrIdPBS',
			hidden:false
		},{
			xtype:'searchresultgrid',
			title :getProgramandcourseTranslation('DELAYED_COURSE'),
			width: '100%',
			itemId:'facultydelayedCourseSearchGrIdCBS',
			hidden:true
		}]
	}]

});