/**
 * Akshay Sharma
 * 
 */
Ext.define('Academia.view.programCourseDashboard.CourseSearchAttendance', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.coursesearchattendance',  
	plugins : "formlabelrequired",
	autoScroll: true,
	frame: false,
	cls:'customSearchPanel',
	method: 'POST',
	standardSubmit: false,
	isMinWidthNotRequired: true,
	items: [{
	    xtype: 'fieldcontainer',
	    layout: {
	        type: 'hbox'
	    },
	    defaults: {
	        width: '256',
	        labelAlign: 'top'
	    },
	    items: [{
	        xtype: 'customcombobox',
	        name: 'academicTerm',
	        itemId: 'academicTermId',
	        width: 256,
	        fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
	        store: 'common.AcademicTermStore',
	        valueField: 'id',
	        displayField: 'value',
	        allowBlank: false,
	        forceSelection:true,
	        typeAhead : false,
	    },{
        	xtype: 'customcombobox',
			name: 'studentId',
			itemId: 'studentId',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store:Ext.create('Academia.store.coursetransaction.studentenrollment.studentenrollmentdetail.FacultyParamCourseStudentStore'),
			valueField: 'id',
			width: 256,
			displayField: 'valueCode',
			queryParam:'name',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			//typeAhead:true,
			forceSelection:true,
			disabled:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{studentCode} / {studentName}' +
					'</div>';
				}
			}
	    }]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width: '256',
			labelAlign : 'top'
		},
		items : [{
			xtype : 'multiselectcombofield',
			width: 536,
			cls: 'multiselectAcademyLocation',
			fieldLabel : getCommonTranslation('COURSE_CODE_NAME'),
			name : 'courseId',
			itemId : 'course_Id',
			store:Ext.create('Academia.store.programCourseDashboard.ParameterisedCoursesStore'),
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			disabled:true,
			forceSelection : true,
			allowBlank:true,
			queryParam:'name',
		},{
        	xtype: 'customcombobox',
    		name: 'studentStatusItemId',
    		itemId:'studentStatusItemId',
    		value:'Active',
    		store: 'student.studentprofile.ManuallyStudentStatusStore',
    		fieldLabel: getCommonTranslation('STUDENT_STATUS'),
    		valueField: 'value',
    		displayField: 'value',
    		editable: false,
    	    cls:'commonAutoHeightMultiselectField',
    	}]
	},{
		xtype : 'fieldcontainer',
		itemId:'programBatch_Id',
		width: 'auto',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'hidden',
			name : 'id'
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			name : 'programId',
			itemId : 'programBatch_programId',
			store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			displayField:'valueCode',
			valueField:'id',
			width: 256,
			typeAhead:true,
			disabled:true,
			allowBlank: false,
			forceSelection:true,
			queryParam:'name',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'programBatch_batchId',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),
			disabled:true,
			store: Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
			forceSelection:true,
			width: 256
		},{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'programBatch_periodId',
			fieldLabel: getExaminationTranslation('PERIOD'),
			store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			displayField:'value',
			valueField:'id',
			forceSelection:true,
			typeAhead:false,
			disabled:true,
			width: 256
		},]
	},{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout:'hbox',
		itemId:'dateContainer',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel : getCourseTxCommonTranslation('SECTION'),
			width: 256,
			labelAlign: 'top',
			name : 'sectionId',
			itemId : 'programCoursection_ID',
			store:Ext.create('Academia.store.common.ParameterizedProgramBatchPeriodStore'),
			displayField:'value',
			valueField:'id',
			typeAhead : false,
			disabled:true,
			forceSelection : true
		},{
			xtype : 'datefield',
			fieldLabel : getProgramandcourseTranslation('START_DATE'),
			name : 'startDate',
			itemId:'startDate',
			endDateField : 'endDate',
			vtype : 'daterange',
			maxValue:new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype : 'datefield',
			fieldLabel :getProgramandcourseTranslation('END_DATE'),
			name : 'endDate',
			itemId : 'endDate',
			startDateField : 'startDate',
			vtype : 'daterange',
			maxValue:new Date(),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: '100%',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true,
			margin: '0 44 0 0'
		},{
			xtype: 'button',
			text: getCourseTxCommonTranslation('RESET'),
			itemId: 'resetBtn',
			//buttonAlign: 'left',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE	        				
		}]
	}
	]
});