/**
 * @author Utsav Chandvaniya
 */
Ext.define('Academia.view.programCourseDashboard.GeneralSummarySearch', {   
	extend : 'Ext.form.Panel',
	alias : 'widget.generalsummarysearch',
	autoScroll: false,
	frame: false,
	plugins : "formlabelrequired",
	cls:'panelNoSpace',
	items: [{
		xtype:'form',
		cls:'customSearchPanel',
		items:[{
			xtype:'fieldcontainer',
			layout: 'hbox',
			width: '100%',
			cls:'panelNoSpace',
			items:[{
				xtype: 'radiogroup',
				itemId:'topOrBottomAttendanceId',				
				columns: 2,
				vertical: false,				
				items: [
				        { boxLabel: getProgramandcourseTranslation('TOP_ABSENTEEISM'), name: 'topOrBottomAttendance', inputValue: 'TOP_ABSENTEEISM',checked:true},
				        { boxLabel: getProgramandcourseTranslation('BOTTOM_ABSENTEEISM'), name: 'topOrBottomAttendance', inputValue: 'BOTTOM_ABSENTEEISM'}
				        ]
			},{
				xtype: 'textfield',	              
				name: 'attendancePercentage',
				itemId:'attendancePercentage',
				fieldLabel: getProgramandcourseTranslation('ATTENDANCE_IN_PERCENTAGE')
			}]
		},{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{				
				xtype: 'customcombobox',
				fieldLabel: getProgramandcourseTranslation('VIEW_STASTISTICS'),              
				name: 'stastisticsId',
				itemId:'stastisticsId',
				store: 'programCourseDashboard.StastisticsData',
				valueField: 'id',
				displayField: 'value',
				queryMode:'local',
				editable: false,
				allowBlank: false	
			}/*{
				xtype: 'textfield',	              
				name: 'attendancePercentage',
				itemId:'attendancePercentage',
				fieldLabel: getProgramandcourseTranslation('ATTENDANCE_IN_PERCENTAGE')
			}*/]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'programId',
				itemId:'programId',        
				fieldLabel: getProgramandcourseTranslation('Program'),

				store:'common.ProgramsByAcademyLocationsIds',
				valueField:'id',
				displayField:'value',
				hidden:true,
				queryMode:'local'
			},{
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'batchId',
				fieldLabel: getProgramandcourseTranslation('BATCH'),

				hidden:true,
				store:'enquiry.AcademicBatchStore',
				valueField:'id',
				displayField:'value'
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults :{
				width: 256,
				labelAlign:'top'
			},
			items :[{
				xtype: 'customcombobox',
				name: 'periodId',
				itemId:'periodId',
				fieldLabel: getProgramandcourseTranslation('PERIOD'),

				hidden:true,
				store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField:'value',
				valueField:'id'
			},{
				xtype: 'customcombobox',
				name: 'sectionId',
				itemId:'sectionId',
				fieldLabel: getProgramandcourseTranslation('SECTION'),

				hidden:true,
				store:'attendance.SectionAndFacultyByPeriodID',
				displayField:'sectionCode',
				valueField:'sectionId'
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			defaults:{
				width: 256,
				labelAlign:'top'
			},
			items :[{
				xtype:'customcombobox',
				name:'departmentId',
				itemId:'departmentId',
				store:'department.DepartmentAcademyLocationWiseStore',
				displayField:'value',
				valueField:'id',
				fieldLabel:getProgramandcourseTranslation('DEPARTMENT'),

				hidden:true
			},{
				xtype :'customcombobox',
				name:'subDepartmentId',
				itemId:'subDepartmentId',
				store:'department.ChildDepartmentStore',
				fieldLabel:getProgramandcourseTranslation('SUB_DEPARTMENT'),
				displayField:'name',
				valueField:'id',

				hidden:true
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'btnSearch',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'btnReset',
				// buttonAlign: 'left',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
	},{
		xtype:'panel',
		style:{margin:'-3px 10px 25px 10px !important'}, 
		items:[{
			xtype:'searchresultgrid',
			title :getProgramandcourseTranslation('TOP_AND_BOTTOM_ATTENDANCE'),
			itemId:'topandbottomattendancegridforfaculty',
			width:'100%',
			hidden: false,
			headerFix:{
				headerFix: true,
				portalIdsWithStructure: {
					'dashboardmainstructure':1
				}
			}
		},{
			xtype:'searchresultgrid',
			title :getProgramandcourseTranslation('TOP_AND_BOTTOM_ATTENDANCE'),
			itemId:'topandbottomattendancegridforstudent',
			width:'100%',
			hidden : true,
			headerFix:{
				headerFix: true,
				portalIdsWithStructure: {
					'dashboardmainstructure':1
				}
			}
		}]
	}]
});