/**
 * @author Utsav Chandvaniya 
 */
Ext.define('Academia.view.programCourseDashboard.GeneralSummaryStructure',{
	extend : 'Ext.form.Panel',
	alias : 'widget.generalsummarystructure',  
	autoScroll:false,
	frame:false,
	border:false,
	items: [{
		xtype:'form',
		cls:'customSearchPanel',
		isMinWidthNotRequired: true,
		items:[{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				fieldLabel: getPersonModuleTranslation('EMPLOYEE_ID_OR_NAME'),
				name: 'facultyCodeItem',
				itemId:'facultyCodeItemId',
//				store:'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
				store:'common.ActiveUserStore',
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'name',
				minChars:3,
				typeAhead:false,
				hideTrigger:true,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code} / {value}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				name: 'programId',
				itemId:'programId',        
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//				translationKey:'Program',
				store:'common.ProgramsByAcademyLocationsIds',
				valueField:'id',
				displayField:'valueCode',
				forceSelection : true,
				minChars:3,
				queryParam:'programName',
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},
			 {
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'batchId',
				fieldLabel: getProgramandcourseTranslation('BATCH'),
				store:'enquiry.AcademicBatchStore',
				valueField:'id',
				displayField:'value'
			}]
		},{
			xtype: 'fieldcontainer',
			width: '100%',
			layout:'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'periodId',
				itemId:'periodId',
				fieldLabel: getProgramandcourseTranslation('PERIOD'),
				store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField:'value',
				valueField:'id'
			},{
				xtype: 'customcombobox',
				name: 'sectionId',
				itemId:'sectionId',
				fieldLabel: getProgramandcourseTranslation('SECTION'),
				store:'attendance.SectionAndFacultyByPeriodID',
				displayField:'sectionCode',
				valueField:'sectionId'
			}]
		},{ 
			xtype : 'fieldcontainer',
			width: '100%',
			layout:'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items : [{
				xtype : 'datefield',
				fieldLabel : getProgramandcourseTranslation('FROM_DATE'),
				name : 'fromDate',
				itemId:'fromDate',
				endDateField : 'toDate',
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				//--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange'
			},{
				xtype : 'datefield',
				fieldLabel :getProgramandcourseTranslation('TO_DATE'),
				name : 'toDate',
				itemId : 'toDate',
				startDateField : 'fromDate',
				listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat : CONSTANTS.SUBMIT_DATE_FORMAT,
				vtype : 'daterange'
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				ui: 'CustomBtnSubmit',
				//style:{marginLeft:'10px'},
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'btnReset',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]
		}]
	},{
		xtype:'facultyutilizationgrid',
		itemId:'facultyWorkLoadReportId',
		title :getProgramandcourseTranslation('TOP_AND_BOTTOM_FACULTY_UTILIZATION'),
		headerFix:{
			headerFix: true,
			portalIdsWithStructure: {
				'dashboardmainstructure':1
			}
		}
	}]
});
