Ext.define('Academia.view.programCourseDashboard.PncTimeTableSearchResultGrid',{
	extend:'Ext.grid.Panel',
	alias:'widget.pnctimetablesearchresultgrid',
	border: true,
	margin:'0 0 0 0',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	autoScroll: false,
	enableColumnHide: false,
	enableColumnMove: false,
	 height   : 200,
	 width    : 400,
	viewConfig: {
		 trackOver : false,
		 stripeRows: CONSTANTS.STRIPEROWS
	},
	features: [{
		ftype: 'summary',
		showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
	}],
	initComponent: function() {
		var me = this;
		var url = SERVERURL.PATH_GET_DETAIL_TIME_TABLE_DAY_WISE;
		if (url == '') {
			Ext.Error.raise('url parameter is empty! You have to set proper url to get data form server.');
		}
		else {
			 Ext.applyIf(me, {
	                columns: [],
	                forceFit: true,
	                store: Ext.create('Ext.data.Store', {
	                    // Fields have to be set as empty array. Without this Ext will not create dynamic model.
	                    fields: [],
	                    // After loading data grid have to reconfigure columns with dynamic created columns
	                    // in Ext.ux.data.reader.DynamicReader
	                    listeners: {
	                        'load': function(store, meta) {
	                        	if(!isNullOrEmpty(store.proxy.reader.metaData)){
	                        		var columns = store.proxy.reader.metaData.columns;
		                        	me.configureColumns(columns,store);
	                        	}
	                        }
	                    },
	                    autoLoad: true,
	                    remoteSort: false,
	                    remoteFilter: false,
	                    remoteGroup: false,
	                    proxy: {
	                    	type : 'rest',
	            			api:{
	            				read:url
	            			},
	            			reader: {
	            				type:'dynamicReader'
	            			}
	                    }
	                })
	            });
		}
		me.callParent(arguments);
	},
	configureColumns: function(columnModels, store,extraColumns) {
		var this$=this;
        this.getSelectionModel().deselectAll(true);
        var columns = [];
        /**
         * @author Akshay.Kalbhor
         * added checks for status and weatherinternal , for translation of the displayed values to internal/external and active/inactive.
         * Bug Id : [#33622 & 33621]
         */
        var alinfomodel = Academia.model.authentication.ALInfoModel;
   	    var wheatherSchool = alinfomodel.get('wheatherSchool');
        Ext.each(columnModels, function(columnModel) {
	        	columns.push(Ext.create('Ext.grid.column.Column', {
            	text:this$.getFieldLabel(columnModel),
                dataIndex: columnModel.text,
                resizable: false,
               // data:columnModel.defaultValue,
                tooltip : this$.getFieldLabel(columnModel), //+ getCommonTranslation('DRAGANDDROPTEXT'),
                //menuDisabled : true,
                sortable: false,
                flex:0.4,
                renderer: function(value,metaData,record) {
                	if(isArray(value)){
                		if(value.length!=0){
                			if(value.length>1){
                    			metaData.tdCls ='timeTableDashletbackgroundWhiteCls';
                    			return "<a href='#'>"+value.length+"</a>";
                    		}else if(value[0].whetherAttendanceMarked == true){
                    			if(value[0].whetherDeleted){
                    				metaData.tdCls ='timeTableDashletbackgroundWhiteCls';
                    				return "<div>"+value[0].courseShortName+"</div>"+"<div>"+value[0].facultyShortName+"</div>"+'<div><span class="required" style="color:red">*</span></div>';	
                    			}else{
                    				metaData.tdCls = 'timeTableDashletbackgroundGreenCls';
                    				return "<div>"+value[0].courseShortName+"</div>"+"<div>"+value[0].facultyShortName+"</div>";
                    			}
                    		}else{
                    			if(value[0].whetherDeleted){
                    				metaData.tdCls ='timeTableDashletbackgroundWhiteCls';
                    				return "<div>"+value[0].courseShortName+"</div>"+"<div>"+value[0].facultyShortName+"</div>"+'<div><span class="required" style="color:red">*</span></div>';	
                    			}else{
                    				if(value[0].whetherRedColor){
                    					metaData.tdCls = 'timeTableDashletbackgroundRedCls';
                        				return "<div>"+value[0].courseShortName+"</div>"+"<div>"+value[0].facultyShortName+"</div>";
                    				}else{
                    					metaData.tdCls = 'timeTableDashletbackgroundWhiteCls';
                        				return "<div>"+value[0].courseShortName+"</div>"+"<div>"+value[0].facultyShortName+"</div>";
                    				}
                    			}
                    		}
                		}else{
                			metaData.tdCls ='timeTableDashletbackgroundWhiteCls';
                			return 'No Session';
                		}
                		
                	}else{
                		if(value == 'SECTION_GROUP_NAME'){
                			metaData.tdCls ='timeTableDashletbackgroundWhiteCls';
                			return getCommonTranslation('SECTION_GROUP_NAME');
                		}else{
                			metaData.tdCls ='timeTableDashletbackgroundWhiteCls';
                			 return value;
                		}
                		
                		 
                	}
                  
                }
            }));
        
        });
 
        Ext.suspendLayouts();
        this.reconfigure(store, columns);
        Ext.resumeLayouts(true);
    },
    getFieldLabel: function(column) {
        return getCommonTranslation(column.text);
    }
});


