/**
 * @author Rajkumar.patidar
 */
Ext.define('Academia.view.programCourseDashboard.ProgramPromotionStructure',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.programpromotionstructure',  
	autoScroll:false,
	frame:false,
	border:false,
	items: [{
		xtype:'form',
		cls:'customSearchPanel',
		isMinWidthNotRequired: true,
		items:[{
			xtype:'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 256,
				labelAlign: 'top'
			},
			items:[{

				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('INTAKE_YEAR'),
				name : 'intakeYearName',
				itemId : 'intakeYearId',
				displayField:'value',
				valueField:'id',
//				width: 256,
				typeAhead:true,
				forceSelection:true,
				minChars:3,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				},
				listeners  :{
					render : function(combo){
						var store=Ext.create('Academia.store.common.IntakeYearStore');
						combo.bindStore(store)
					}
				}
			
			},{
				xtype: 'customcombobox',
				name: 'programId',
				itemId:'programId',        
				fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//				translationKey: 'Program',
				store:'common.ProgramByAcademyLocationStore',
				valueField:'id',
				displayField:'valueCode',
				typeAhead:false,
				forceSelection:true,
				queryParam: 'programName',
			    minChars: 3,
			    emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			    listConfig: {
	                listeners: {
	                    beforeshow: function(
	                        picker) {
	                        picker.minWidth = picker
	                            .up('combobox')
	                            .getSize().width;
	                    }
	                },
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{code} / {value}' +
	                        '</div>';
	                }
	            }
			},{
				xtype: 'customcombobox',
				name: 'batchId',
				itemId:'batchId',
				fieldLabel: getProgramandcourseTranslation('BATCH'),
				store:'enquiry.AcademicBatchStore',
				valueField:'id',
				displayField:'value',
				disabled:true,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'periodId',
				itemId:'periodId',
				fieldLabel: getProgramandcourseTranslation('PERIOD'),
				store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
				displayField:'value',
				valueField:'id',
				typeAhead:true,
				disabled:true,
				forceSelection:true
			}]
		},{
			xtype: 'fieldcontainer',
			width: '100%',
			layout:'hbox',
			defaults : {
				width: 256,
				labelAlign : 'top'
			},
			items: [{
				xtype: 'customcombobox',
				name: 'sectionId',
				itemId:'sectionId',
				fieldLabel: getProgramandcourseTranslation('SECTION'),
				store:'attendance.SectionAndFacultyByPeriodID',
				displayField:'sectionCode',
				valueField:'sectionId',
				disabled:true,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'promotionStatus',
				itemId:'promotionStatusId',
				fieldLabel: getProgramandcourseTranslation('PROMOTION_STATUS'),
				store:'coursetransaction.promotion.PromotionStatusWithoutPending',
				displayField:'value',
				valueField:'id',
				forceSelection:true,
				typeAhead:true
			}]
		},{
			xtype: 'fieldcontainer',
			width: 'auto',
			layout: 'hbox',
			cls: 'customSearchPanelBtnsFieldContainerCls',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				ui: 'CustomBtnSubmit',
				//style:{marginLeft:'10px'},
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'btnReset',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]
		}]
	},{
		xtype:'panel',
		items:[{
			xtype:'programpromotiongrid',
			itemId:'programpromotiongrid',
			headerFix:{
				headerFix: true,
				portalIdsWithStructure: {
					'dashboardmainstructure':1
				}
			}
		}]
	}]
});
