/**
 * @author Abhishek Bais
 */
Ext.define('Academia.view.programCourseDashboard.StudentCourseEnrollmentReportSearchForm', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.studentcourseenrollmentreportsearchform',
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    defaults: {
        labelAlign: 'top',
        width: '100%'
    },
    plugins: "formlabelrequired",
	isMinWidthNotRequired: true,
    items: [{
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: '256'
            },
            items: [{
                    xtype: 'customcombobox',
                    name: 'PROGRAM_GROUP',
                    itemId: 'programGroupId',
                    fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
                    store: 'program.ProgramGroupStore',
                    displayField: 'value',
                    width: 256,
                    valueField: 'id',
                    forceSelection: true,
                    allowBlank: false
                },
                {
                    xtype: 'customcombobox',
                    fieldLabel: getCommonTranslation('INTAKE_YEAR'),
                    name: 'intakeYear',
                    itemId: 'intakeYear',
                    displayField: 'value',
                    valueField: 'id',
                    width: 256,
                    typeAhead: true,
                    forceSelection: true,
                    minChars: 3,
                    listConfig: {
                        listeners: {
                            beforeshow: function(
                                picker) {
                                picker.minWidth = picker
                                    .up('combobox')
                                    .getSize().width;
                            }
                        },
                        loadingText: getCommonTranslation('SEARCHING'),
                        emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                        getInnerTpl: function() {
                            return '<div class="search-item">' +
                                '{code}' +
                                '</div>';
                        }
                    },
                    listeners: {
                        render: function(combo) {
                            var store = Ext
                                .create('Academia.store.common.IntakeYearStore');
                            combo.bindStore(store)
                        }
                    }
                },
                {
                    xtype: 'customcombobox',
                    fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
                    name: 'academicTerm',
                    itemId: 'academicTerm',
                    displayField: 'value',
                    valueField: 'id',
                    typeAhead: true,
                    allowBlank: false,
                    forceSelection: true,
                    width: 256,
                    hidden: false,
                    listeners: {
                        render: function(combo) {
                            var store = Ext
                                .create('Academia.store.common.AcademicTermStoreForIntakeYearId');
                            combo.bindStore(store)
                        }
                    }
                }
            ]
        },
        {
			xtype:'panel',
			itemId:'panelIdH',
			layout : 'vbox',
			width: '100%',
			margin: '0 0 0 -9',
			padding: '0 0 0 0',
			style:{
				marginLeft:'0px',
				marginTop:'0px'
			},
			items:[{
			 xtype : 'fieldcontainer',
	       	 layout : 'hbox',
	       	 width: '100%',
	       	 defaults : {
	       		 labelAlign : 'top',
	       		 width: '256'
	       	 },
	       	 layout : {
	       		 type : 'hbox'
	       	 },
			margin: '0 0 0 0',
			padding: '0 0 0 0',
			 items:[{
		            xtype: 'customcombobox',
		            width: 256,
		            name: 'programItem',
		            itemId:'programItemId',
		            // store:
		            // 'program.ProgramCodeOrNameSmartSearch',
		            store: 'program.ProgramByGroupIdStore',
		             fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
		            // translationKey:
		            // 'PROGRAM_CODE_OR_NAME',
		            valueField: 'id',
		            displayField: 'valueCode',
		            queryParam: 'qry',
		            minChars: 3,
		            allowBlank: false,
		            typeAhead: false,
		            // hideTrigger:false,
		            // triggerCls : Ext.baseCSSPrefix +
		            // 'form-search-trigger',
		            // enableKeyEvents : 'true',
		            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		            // triggerAction: '',
		            forceSelection: true,
		            listConfig: {
		                listeners: {
		                    beforeshow: function(
		                        picker) {
		                        picker.minWidth = picker
		                            .up('combobox')
		                            .getSize().width;
		                    }
		                },
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                        '{code} / {value}' +
		                        '</div>';
		                }
		            }

		        },
		        {
		            xtype: 'customcombobox',
		            name: 'BATCH_NAME',
		            itemId: 'batchId',
		            fieldLabel: getPersonModuleTranslation('BATCH'),
		            disabled: true,
		            editable: false,
		            queryMode: 'local',
		            displayField: 'value',
		            valueField: 'id',
		            width: 256,
		            listeners: {
		                render: function(combo) {
		                    var store = Ext
		                        .create('Academia.store.program.programbatchdetail.BatchStore');
		                    combo.bindStore(store);
		                }
		            }
		        },
		        {
		            xtype: 'customcombobox',
		            itemId: 'periodId',
		            disabled: true,
		            editable: false,
		            displayField: 'value',
		            valueField: 'id',
		            queryMode: 'local',
		            width: 256,
		            fieldLabel: getPersonModuleTranslation('PERIOD'),
		            name: 'PERIOD_NAME',
		            listeners: {
		                render: function(combo) {
		                    var store = Ext
		                        .create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
		                    combo.bindStore(store);
		                }
		            }
		        },
		        {
					 xtype: 'button',
					 itemId: 'addDetailedBtn',
					 width: 'auto',
					 cls: 'CustomBodyBtnSettings',
					 //text: getCommonTranslation('ADDBUTTONTEXT'),
					 tooltip: getCommonTranslation('ADD'),
					 style:{
						 marginTop:'24px'
					 }
				}]
		}]
		},
        {
        	xtype: 'fieldset',
			collapsible : true,
			collapsed: true,
			title: getCommonTranslation('MORE_FILTERS'),
			titleCollapse: true,
			width: '100%',
            items: [{
			    xtype: 'fieldcontainer',
			    layout: 'hbox',
			    //width: '100%',
				
			    defaults: {
			        labelAlign: 'top',
			        width: '256'
			    },
			    items: [{
	            	xtype: 'customcombobox',
					name: 'STUDENT_ID',
					itemId: 'studentId',
					fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
					store: 'feeandpayment.reports.Student',
					valueField: 'id',
					width: 256,
					displayField: 'valueCode',
					queryParam:'studentNameOrCode',
					triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
					enableKeyEvents  : 'true',
					minChars:3,
					//typeAhead:true,
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					triggerAction: '',
					hideTrigger:false,
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{studentCode} / {studentName}' +
							'</div>';
						}
					}
	            },{
					xtype: 'statusCombo',
					name: 'STATUS',
					itemId:'statusComboItemId',
					width: 256,
					value:true,
					editable:false
				},
				{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('STUDENT_ENROLLMENT_STATUS'),
			name : 'enrollmentStatusId',
			itemId : 'enrollmentStatusId',
			width: 256,
			store : 'Academia.store.programCourseDashboard.StudentEnrollmentStatusStore',
			labelAlign : 'top',
			displayField : 'value',
			valueField : 'id',
		}]
			}]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
    		cls: 'customSearchPanelBtnsFieldContainerCls',
            layout: 'hbox',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'searchBtn',
                //buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind : true
            }, {
                xtype: 'button',
                text: getCommonTranslation('RESET'),
                itemId: 'resetBtn',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }
    ]
});