/**
 * @author Deepika P
 *  V2D-239844
 */
Ext.define('Academia.view.receipt.receiptsettings.PaymentGroupChildFormWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.paymentgroupchildformwindow',

    title: getCommonTranslation('STD_MASTER_CHILD_FORM'),

    autoScroll: true,
    maxHeight: 600,
    modal: true,
    flex: 0.8,

    items: [{
        xtype: 'form',
        itemId: 'paymentGroupChildForm',
        plugins : "formlabelrequired",
       items:[{
			  xtype:'fieldcontainer',
			  layout:{
					type:'hbox'
				},
			  defaults:{
				labelAlign:'top',
				width: 256
			  },
			  items: [{
				  xtype:'hidden',
				  itemId:'paymentTermId'
			  },{
				  xtype:'textfield',
				  fieldLabel:getCommonTranslation('PAYMENT_TERM_CODE'),
				  allowBlank:false,
				  maxLength :100,
				  itemId:'itemCode',
				  name:'code'
			  },{
				  xtype:'textfield',
				  fieldLabel:getCommonTranslation('PAYMENT_TERM_NAME'),
				  allowBlank:false,
				  maxLength :100,
				  itemId:'itemValue',
				  name:'name'
			  }]
		  },{
			  xtype:'fieldcontainer',
			  layout:{
					type:'hbox'
				},
			  defaults:{
				labelAlign:'top',
				width: 256
				
			  },
			  items: [{
				  xtype:'numberfield',
				  fieldLabel:getCommonTranslation('SEQUENCE_NO'),
				  allowBlank:true,
				  itemId:'sequenceNo',
				  name:'sequenceNo',
				  maxValue:999,
				  maxLength: 3,
				  minValue:1
			  },{
				  xtype: 'checkboxfield',
				  width: 300,
				  labelAlign: 'right',
				  itemId:'isDefaultId',
				  boxLabel: getFeeAndPaymentCommonTranslation('IS_DEFAULT'),
				  name: 'isDefault',
				  inputValue : true,
				  style:{
					  marginTop:'24px !important'
				  }
			  }]
		  },{
			  xtype:'fieldcontainer',
			  items:[{
					xtype:'button',
					action: 'Submit',
					itemId: 'formSubmitButtonId',
					text: getCommonTranslation('SAVE'),
					ui: 'CustomBtnSubmit',
					scale: CONSTANTS.BUTTONSIZE,
					formBind: true,
			},{
					xtype:'button',
					text: getCommonTranslation('CANCEL'),
					ui: 'CustomBtnCancel',
					scale: CONSTANTS.BUTTONSIZE,
					itemId:'cancelItemId'
				}]
		  }]
    }]

});