/**
 *  @author manisha wagh
 */

Ext.define('Academia.view.receipt.receiptsettings.PaymentGroupMappedGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.paymentgroupmappedgrid',
	store : 'receipt.receiptsettings.PaymentGroupMappedGridStore',
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	border: true,
	autoScroll: false,
	frame:false,
	 //selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
    /*selModel: {
		 //showHeaderCheckbox: false,
	     checkOnly : true, //I have option checkOnly: true that mean rows can only be selected by clicking on the checkbox column.
	     allowDeselect: false
   },*/
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'receipt.receiptsettings.PaymentGroupMappedGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getFeeAndPaymentCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getFeeAndPaymentCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header :  getCommonTranslation('ACADEMY'),
		dataIndex : 'academyName',
		flex:1
	},{
		header :  getCommonTranslation('LOCATION'),
		dataIndex : 'locationName',
		flex:1
	},{
		header : getCommonTranslation('PROGRAM'),
		dataIndex : 'programName',
		flex:1
	},{
		header :getCommonTranslation('BATCH'),
		dataIndex : 'batchName',
		flex:1
	},{
		header : getCommonTranslation('PERIOD'),
		dataIndex : 'periodName',
		flex:1
	},{
		header : getCommonTranslation('SEAT_NAME'),
		dataIndex : 'seatName',
		flex:1
	}/*,{
		header : getFeeAndPaymentCommonTranslation('STATUS'),
		dataIndex : 'status',
		flex:1
	}*/]
});