/**
 * Mahendra
 */
Ext.define('Academia.view.registrationsetup.RegistrationSetupCopyWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.registrationsetupcopywindow',
	modal: true,
	autoScroll:true,
	title: getCommonTranslation('COPY_REGISTRATION_SETUP'),
	maxHeight:500,
	height:250,
	width: '42%',
	items: [{
		xtype: 'form',
		method: 'POST',
		itemId:'registrationsetupcopywindow',
		margin: 0,
		layout: {
			type: 'vbox'
		},
		defaults: {
			labelAlign: 'top',
			autoScroll:true,
			
		},
		plugins:"formlabelrequired",
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id',
			itemId : 'id'
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 256
			},
			items: [{
				xtype: 'customcombobox',
				name: 'academicTerm',
				itemId : 'academicTerm',
				fieldLabel: getCommonTranslation('ACADEMIC_TERM'),
				store : Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
	        	displayField : 'value',
	        	valueField : 'id',
	        	allowBlank:false,
				typeAhead:true,
				editable : false,
				style:{
					marginLeft:'15px'
				}
				
			},{
				xtype : 'textfield',
				name : 'registrationSetupName',
				itemId:'registrationSetupName',
				fieldLabel : getCommonTranslation("REGISTRATION_SETUP_NAME"),
				allowBlank:false,
				maxLength: 50,
				style:{
					marginBottom:'5px'
				}
			}]
		},{
			xtype: 'fieldcontainer',
			width:'100%',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SAVE'),
				itemId: 'btnSubmit',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true,
			},{
				xtype: 'button',
				text: getCommonTranslation('CANCEL'),
				itemId: 'btnCancel',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE,
			}]	
		}]
	}]
});