/**
 */
Ext.define('Academia.view.registrationsetup.RegistrationSetupFilter', {
	extend: 'Ext.form.Panel',
	alias: 'widget.registrationsetupfilter',
	autoScroll: false,   
	frame: false,
	cls:'customSearchPanel',
	plugins : "formlabelrequired",
	items : [{
		xtype : 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 450,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'multiselectcombofield',
			width: 536,
			name: 'multiselectAcademyLocation',
			cls: 'multiselectAcademyLocation',
			itemId: 'multiselectAcademyLocationId',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store:Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
			displayField:'value',
			valueField:'id',
			matchFieldWidth:true,
			queryMode:'local',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}

		},{
			xtype : 'customcombobox',
			width: 256,
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			valueField : 'id',
			editable : true,
			queryMode:'local',
             typeAhead : false,
             forceSelection : true,
             anyMatch : true
		}]

	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		layout : 'hbox',
		defaults : {
			width: 256,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			name : 'programId',
			width: 536,
			itemId : 'programId',
			store:Ext.create('Academia.store.registrationsetup.RegistrationSetupProgramComboStore'),
			displayField : 'valueCode',
			valueField : 'id',
			queryParam : 'programName',
			minChars : 3,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents : 'true',
			hideTrigger : false,
			forceSelection : true,
			//allowBlank : false,
			emptyText : getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig : {
				listeners : {
					beforeshow : function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText : getCommonTranslation('SEARCHING'),
				emptyText : getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl : function() {
					return '<div class="search-item">' + '{code} / {value}' + '</div>';
				}
			}
		},{
			xtype : 'customcombobox',
			name : 'batchId',
			itemId : 'batchId',
			fieldLabel : getCourseTxCommonTranslation('BATCH'),
			disabled : true,
			store:Ext.create('Academia.store.registrationsetup.RegistrationSetupBatchComboStore'),
			valueField : 'id',
			displayField : 'value',
			forceSelection : true
			//allowBlank : false
		}]
	},{
		xtype:'fieldcontainer',
		width: '100%',
		layout : 'hbox',
		defaults: {
			labelAlign:'top',
			width: 256
		},
		items: [{
			xtype : 'customcombobox',
			name : 'periodId',
			itemId : 'periodId',
			fieldLabel : getCourseTxCommonTranslation('PERIOD'),
			store:Ext.create('Academia.store.registrationsetup.RegistrationSetupPeriodComboStore'),
			displayField : 'value',
			valueField : 'id',
			forceSelection : true,
			//allowBlank : false,
			disabled : true
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation("REGISTRATION_SETUP_NAME"),
			name: 'registrationSetupName',
			itemId:'registrationSetupNameId',
			editable: true,
			store: 'registrationsetup.RegistrationSetupNameComboStore',
			displayField: 'value',
			valueField: 'id',
			minChars:3,
			typeAhead:true,
			forceSelection :true,
			queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation("REGISTRATION_TERM"),
			name: 'registrationTerm',
			itemId:'registrationTermId',
			editable: true,
			store: 'registrationsetup.RegistrationTermComboStore',
			displayField: 'value',
			valueField: 'id',
			minChars:3,
			typeAhead:true,
			forceSelection :true,
			queryParam:'qry',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchBtn',
			buttonAlign: 'left',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,
			formBind:true
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetBtn',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});