/**
 * This panel is used for student dashboard view
 * @author Sachin.Bangar
 */
Ext.define('Academia.view.reports.admission.dashboard.AdmissionDashboardView', {
    extend: 'Ext.form.Panel',
    alias: 'widget.admissiondashboardview',
    autoScroll:true,
	frame:false,
	cls: 'panelNoSpace',
		
	items : [{
		xtype:'panel',
		items:[{
			xtype: 'organizationunit',
	    	itemId: 'admissionDashboardOrganizationUnit'
		},{
			xtype: 'panel',
			itemId: 'admissionReportView',
			autoScroll: false,
			width: '100%',
			cls: 'panelNoSpace',
			layout: {
				type: 'hbox'
			},
			items: [{
				xtype: 'treepanel',
				itemId:'admissionReportTreePanelItemId',
				title: getFeeAndPaymentCommonTranslation('SELECT_REPORTS'),
				store: 'admission.reports.AdmissionReportTreeStore',
				rootVisible: false,
				cls: 'no-tree-icon enquiryTreePanelWidthCls',
				height: 500,
				width:252,
				frame: true,
				border: false,
				collapsible: true,
				animCollapse: false,
				collapseDirection: 'left',
				titleCollapse: true,
				floatable: false,
				titleAlign: 'left',
				viewConfig: {
				    listeners: {
				        itemmouseenter: function (view, record, item) {
				            var text = record.get('text');
				            item.setAttribute('data-qtip', Ext.String.htmlEncode(text));
				        }
				    }
				},
				listeners: {
					afterrender: function(panel) {
						panel.getEl().on('click', function() {
							if (panel.collapsed) {
								panel.expand();
							}else {
								panel.collapse();
							}
						});
					}
				}
			},{
				xtype: 'admissionreporttabpanel',
				itemId: 'admissionReportTabStructure'
			}]
		}]
	}]
});