/*
 * @author Soham Gurjar
 */

Ext.define('Academia.view.reports.admission.dashboard.DtefCourseEnrollmentFilter', {   
	extend: 'Ext.form.Panel',
	alias: 'widget.dtefcourseenrollmentfilter',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	//layout: 'vbox',
	plugins : "formlabelrequired",
	items: [{
		xtype:'fieldcontainer',
		itemId: 'courseenrollmentdteffilterprogrmbatchseattypecontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name: 'program',
			itemId:'programId',
			 fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			store: 'common.ProgramsByAcademyIdLocationId',
			valueField : 'id',
			displayField:'valueCode',
			valueField:'id',
			forceSelection:true,
			queryParam:'qry',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'+
	                    '</div>';
	                }
	            }
		}, {
			xtype: 'customcombobox',
			name: 'batch',
			itemId:'batchId',
			fieldLabel: getPersonModuleTranslation('BATCH'),
			store: 'common.BatchesByProgramId',
			valueField : 'id',
			displayField : 'value',
			disabled:true,
			editable: false,
			forceSelection:true,
			queryParam:'qry',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'+
	                    '</div>';
	                }
	            }
		},
		{
			xtype: 'customcombobox',
			name: 'periodId',
			itemId:'periodId',
			fieldLabel: getCourseTxCommonTranslation('PERIOD'),
			store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
			valueField: 'id',
			displayField: 'value',
			editable:false,
			/*forceSelection:true,
			queryMode:'local',
			typeAhead : false,
			anyMatch : true,*/
			disabled : true,
			listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'+
	                    '</div>';
	                }
	            }
		}]

	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
            xtype: 'customcombobox',
            name: 'responseStatus',
            fieldLabel: getCommonTranslation('RESPONSE_STATUS'),
            displayField: 'value',
            valueField: 'name',
            allowBlank: true,
            store: Ext.create('Academia.store.common.ResponseStatusStore'),
        },{
			xtype: 'customcombobox',
			name: 'response',
			itemId:'responseId',
			fieldLabel : getCommonTranslation('RESPONSE'),
			store: Ext.create('Academia.store.common.DTEFCourseEnromentResponseStore'),
			valueField : 'value',
			displayField:'value',
			forceSelection:true,
			queryParam:'qry',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{value}'+
	                    '</div>';
	                }
	            }
		},{
        	xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('ADMISSION_STATUS'), 
			name: 'admissionstatus',
			itemId: 'admissionStatus',
			editable: false,
			store: Ext.create('Academia.store.common.AdmissionStatusStore'),                 
			valueField: 'name',
			displayField: 'value'
        }]
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'datefield',
			name:'fromDate',
			itemId:'fromDate',
			vtype : 'daterange',
			endDateField: 'toDate',
			allowBlank : true,
			maxValue: new Date(),
			fieldLabel: getEnquiryTranslation('FROM_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},{
			xtype: 'datefield',
			name:'toDate',
			itemId:'toDate',
			vtype : 'daterange',
			allowBlank : true,
			startDateField: 'fromDate',
			maxValue: new Date(),
			fieldLabel: getCommonTranslation('TILL_DATE'),
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			}
		},
		{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			valueField:'id',
			allowBlank:false,
			editable:false,
			forceSelection: true,
            /*editable: true,
            typeAhead:false,
            cls:'commonAutoHeightMultiselectField',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            minChars:3,
            anyMatch:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}'  +
					'</div>';
				}
			},*/
			listeners  :{
				render : function(combo){
					var store=Ext.create('Academia.store.common.IntakeYearByBatchStore');
					combo.bindStore(store)
				}
			}
		}]
	},{
		xtype:'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'customcombobox',
			name:'studentNameSearch',
			itemId: 'studentFieldItemId',
			store:'coursetransaction.studentenrollment.studentenrollmentdetail.DTEFCourseEnrollmentStudentNameStudentIdBySmartSearch',
			fieldLabel:getCommonTranslation('ADMISSIONCODE_STUDENTNAME_STUDENTCODE'),
			width: 536,
			valueField: 'id',
			displayField: 'value',
			queryParam:'name',
			minChars:3,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			allowBlank:true,
		matchFieldWidth:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'  +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
		items: [{
			xtype: 'button',
			text: getCommonTranslation('SEARCH'),
			itemId: 'searchButtonId',
			formBind:true,
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE               
		},{
			xtype: 'button',
			text: getCommonTranslation('RESET'),
			itemId: 'resetButtonId',
			ui: 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE   
		}]	
	}]
});