/*

 * Pragati laad
 */
Ext.define('Academia.view.reports.admission.dashboard.DtefDashboardView', {
    extend: 'Ext.form.Panel',
    alias: 'widget.dtefdashboardview',
    autoScroll:true,
	frame:false,
	cls: 'panelNoSpace',
		
	items : [{
		xtype:'panel',
		width:'100%',
		items:[{
				xtype:'panel',
				cls:'customSearchPanel',
				defaults: {
					labelAlign:'top',
					width: 256
				},
				items:[{
					xtype: 'multiselectcombofield',
					name: 'multiselectAcademyLocation',
					itemId: 'academyLocationId',
					allowBlank : false,
					fieldLabel : getAdmissionTranslation('ACADEMY_LOCATION'),
					store:'common.AcademyLocationNameSeparated',
					displayField:'value',
					valueField:'id',
					matchFieldWidth:true,
					maxLength:15000,
					width: 960,
					height:58,
					cls:'multiBrandCampusCls',
					style :{
						  marginLeft: '6px'
					},
					queryMode:'local',
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{code}' +
							'</div>';
						}
					}
				}, ,{
					xtype: 'fieldcontainer',
					width : 'auto',
					layout: 'hbox',
					cls: 'customSearchPanelBtnsFieldContainerCls',
					items: [{
						xtype: 'button',
						text: getCommonTranslation('RESET'),
						itemId: 'resetBtn',
						ui: 'CustomBtnCancel',
						scale: CONSTANTS.BUTTONSIZE   
					}]	
				}]  
				
	    		
		},{
			xtype: 'panel',
			itemId: 'admissionDtefReportView',
			autoScroll: false,
			width: '100%',
			cls: 'panelNoSpace',
			layout: {
				type: 'hbox'
			},
			items: [{
				xtype: 'treepanel',
				itemId:'admissionDtefReportTreePanelItemId',
				title: getFeeAndPaymentCommonTranslation('SELECT_REPORTS'),
				store: 'admission.reports.AdmissionDTEFDashboardTreeStore',
				rootVisible: false,
				cls: 'no-tree-icon',
				width: 250,
				height: 500,
				frame: true,
				border: false,
				collapsible: true,
				animCollapse: false,
				collapseDirection: 'left',
				titleCollapse: true,
				floatable: false,
				titleAlign: 'left',
				listeners: {
					afterrender: function(panel) {
						panel.getEl().on('click', function() {
							if (panel.collapsed) {
								panel.expand();
							}else {
								panel.collapse();
							}
						});
					}
				}
			},{
				xtype: 'admissiondtefreporttabpanel',
				itemId: 'admissionDtefReportTabStructure'
			}]
		}]
	}]
});