/**
 * This view is used for Selection Process Overview Search Form
 * 
 * @author Pravin.Surve
 */
Ext.define('Academia.view.reports.admission.dashboard.SelectionProcessOverviewSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.selectionprocessoverviewsearchform',
    //frame: true,
    cls:'customSearchPanel',
    isMinWidthNotRequired: true,
    items: [{
        xtype: 'fieldcontainer',
        itemId: 'selectionProcessProgrmBatchSeatTypeContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	xtype: 'customcombobox',
        	name: 'programId',
        	itemId: 'programId',
        	fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
        	valueField: 'id',                
        	displayField: 'valueCode',
        	forceSelection:true,
        	queryParam:'qry',
        	minChars:3,
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	store:Ext.create('Academia.store.common.ProgramsByAcademyIdLocationId'),
        /*	listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.ProgramsByAcademyIdLocationId');
                    combo.bindStore(store);
                }
            },*/
            listConfig: {   
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    return '<div class="search-item">' +
                    '{code} / {value}'+
                    '</div>';
                }
            }
	            
        }, {
            xtype: 'customcombobox',
            name: 'batchId',
            itemId: 'batchId',
            fieldLabel: getCommonTranslation('BATCH'),
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            store:Ext.create('Academia.store.common.BatchesByProgramId'),
        /*    listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }*/
        }, {
	        xtype: 'customcombobox',
	        fieldLabel: getCommonTranslation('SEAT_TYPE'),
	        editable: false,
	        name: 'seatTypeId',
	        itemId: 'seatTypeId',
	        valueField: 'seatTypeId',                
	        displayField: 'seatTypeName',
	        queryMode: 'local',
	        store:Ext.create('Academia.store.common.SeatTypesByBatchId'),
	   /*     listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.SeatTypesByBatchId');
                    combo.bindStore(store);
                }
            }*/
    }]
    },{
        xtype: 'fieldcontainer',
        itemId: 'selectionProcessQuotaTypeQuotaContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'quotaTypeId',
            itemId: 'quotaTypeId',
            fieldLabel: getAdmissionTranslation('QUOTA_TYPE'),
            displayField: 'code',
            valueField: 'id',
            queryMode: 'remote',
            store:Ext.create('Academia.store.admission.selectionProcess.QuotaTypes'),
   /*         listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.admission.selectionProcess.QuotaTypes');
                    combo.bindStore(store);
                }
            }*/
        }, {
            xtype: 'customcombobox',
            name: 'quotaId',
            itemId: 'quotaId',
            fieldLabel: getAdmissionTranslation('QUOTA'),
            displayField: 'code',
            valueField: 'id',
            queryMode: 'local',
            store:Ext.create('Academia.store.admission.quotas.QuotaLists'),
       /*     listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.admission.quotas.QuotaLists');
                    combo.bindStore(store);
                }
            }*/
        }/*,{
            xtype: 'customcombobox',
            name: 'listId',
            itemId: 'listId',
            fieldLabel: getAdmissionTranslation('LISTS'),
            displayField: 'code',
            valueField: 'id',
            queryMode: 'local',
            listeners: {
                render: function(combo) {
                   // var store = Ext.create('Academia.store.admission.quotas.QuotaLists');
                    combo.bindStore(store);
                }
            }
        }*/]
    },{
		xtype: 'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		itemId: 'selectionProcessAcademyYearContainer',
		defaults: {
			width: 256,
			labelAlign: 'top'
		},
		items: [{
			xtype : 'customcombobox',
			name : 'academicYear',
			itemId: 'academicYear',
			fieldLabel : getFeeAndPaymentCommonTranslation('ACADEMIC_YEAR'),
			store : 'program.programDetails.programBatches.PrimaryAcademicStore',
			valueField : 'id',
			hidden:true,
			displayField : 'yearName',
		},{
			xtype : 'customcombobox',
			name : 'academyYearTenure',			
			itemId : 'academyYearTenure',			
			fieldLabel : getCommonTranslation('ACADEMY_YEAR_TENURE'),//Current Academic Year Tenure
			store : 'organization.academylocations.AcademicTenureStore',
			hidden:true,
			valueField : 'id',
			displayField : 'tenureName',
			editable:false
		}]
		},{
        xtype: 'fieldcontainer',
        layout: 'hbox',
		itemId: 'selectionProcessDateContainer',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getAdmissionTranslation('START_DATE'),
            name: 'startDate',
            itemId :'startDate',
            vtype: 'daterange',
			endDateField: 'endDate',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT,
        },{
            xtype: 'datefield',
            fieldLabel: getAdmissionTranslation('END_DATE'),
            name: 'endDate',
            itemId: 'endDate',
            vtype: 'daterange',
			startDateField: 'startDate',
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat:CONSTANTS.SUBMIT_DATE_FORMAT
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
    	cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getAdmissionTranslation('SEARCH'),
            itemId: 'selectionProcessOverviewSearchButtonId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getAdmissionTranslation('CLEAR_SEARCH'),
            itemId: 'selectionProcessOverviewResetButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});