/**
 * @author priyanshi Sharma
 */
Ext.define('Academia.view.reports.admission.dashboard.dtefInvoices.DtefInvoicesGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.dtefinvoicesgrid',
    title: getCommonTranslation('SEARCH_RESULTS_HEADER'),
    store: 'reports.admission.InvoicesDtefDashboardGridStore',
    cls: 'enqgridsummarycls centerAlignTitle',
    border: true,
    frame: false,
    selType: 'checkboxmodel',
    selModel: {
        multiSelect: true,
        mode: 'SIMPLE',
        checkOnly: false
    },
    isGridConfigurable: true,
    enableColumnHide: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'reports.admission.InvoicesDtefDashboardGridStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function () {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    tbar: [{
        xtype: 'button',
        itemId: 'sendToDTEFBtn',
        tooltip: getCommonTranslation('SEND_TO_DTEF'),
        text: getCommonTranslation('SEND_TO_DTEF'),
        disabled: true
    }],
    columns: [{
        header: getCommonTranslation('STUDENT_ID'),
        dataIndex: 'studentCode',
        flex: 1
    }, {
        header: getCommonTranslation('BILL_ID'),
        dataIndex: 'billNo',
        flex: 1
    },{
        header: getCommonTranslation('NAME'),
        dataIndex: 'studentName',
        flex: 1
    }, {
        header: getCommonTranslation('ACADEMY'),
        dataIndex: 'academyName',
        flex: 1
    }, {
        header: getCommonTranslation('LOCATION'),
        dataIndex: 'locationName',
        flex: 1
    }, {
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex: 1
    }, {
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        flex: 1
    }, {
        header: getCommonTranslation('SEAT_TYPE'),
        dataIndex: 'seatType',
        flex: 1
    }, {
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        flex: 1
    }, {
        header: getCommonTranslation('BILL_TYPE'),
        dataIndex: 'billType',
        flex: 1,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				if(value=='ALL'){
					return getCommonTranslation("All")
				}else if(value=='P_AND_C_FEE'){
					return getCommonTranslation("P_AND_C_FEE");
				}else if(value=='SERVICE_PROVIDED'){
					return getCommonTranslation("SERVICE_PROVIDED");
				}else if(value=='SCHOLARSHIP'){
					return getCommonTranslation("SCHOLARSHIP");
				}else if(value=='SERVICE_RECEIVED'){
					return getCommonTranslation("SERVICE_RECEIVED");
				}else if(value=='LATE_FEE'){
					return getCommonTranslation("LATE_FEE");
				}
			}                        
		}
    }, {
        header: getCommonTranslation('RESPONSE_STATUS'),
        dataIndex: 'responseStatus',
        flex: 1,
        renderer:function(value, meta, record){
			if(!isNullOrEmpty(value)) {
				if(value=='SUCCESS' || value=='success' || value=='Success'){
					return 'Success';
				}else if(value=='FAILED' || value=='failed' || value=='Failed'){
					return 'Failed';
				}else{
					return '';
				}
			}                        
		}
    }, {
        header: getCommonTranslation('RESPONSE'),
        dataIndex: 'response',
        flex: 1
    }, {
        header: getCommonTranslation('RESPONSE_DATE'),
        dataIndex: 'responseDate',
        flex: 1,
        renderer: function (date) {
            if (!isNullOrEmpty(date)) {
                return dateRender(date);
            } else {
                return '';
            }
        }
    }]
});