/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.reports.admission.dashboard.dtefModuleResults.DtefModuleResultsFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.dtefModuleResultsFilter',
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'program',
            itemId: 'programIdModuleResults',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            store: 'reports.admission.dtefModuleResults.ModuleResultsProgramStore',
            valueField: 'id',
            displayField: 'valueCode',
            valueField: 'id',
            forceSelection: true,
            queryParam: 'qry',
            minChars: 3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code} / {value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'batch',
            itemId: 'batchIdModuleResults',
            fieldLabel: getCommonTranslation('BATCH'),
            store: 'reports.admission.dtefModuleResults.ModuleResultsBatchStore',
            valueField: 'batchId',
            displayField: 'batchName',  
            disabled: true,
            forceSelection: true,
            queryParam: 'qry',
            minChars: 3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code} / {value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'periodId',
            itemId: 'periodIdModuleResults',
            fieldLabel: getCommonTranslation('PERIOD'),
            store: 'reports.admission.dtefModuleResults.ModuleResultsPeriodStore',
            valueField: 'id',
            displayField: 'value',
            editable: false,
            disabled: true,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code} / {value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'responseStatus',
            fieldLabel: getCommonTranslation('RESPONSE_STATUS'),
            displayField: 'value',
            valueField: 'name',
            editable: false,
            store: Ext.create('Academia.store.common.ResponseStatusStore')
        }, {
            xtype: 'customcombobox',
            name: 'response',
            itemId: 'responseIdModuleResults',
            fieldLabel: getCommonTranslation('RESPONSE'),
            store: Ext.create('Academia.store.reports.admission.dtefModuleResults.ResponseStore'),
            valueField: 'id',
            displayField: 'id',
            forceSelection: true,
            queryParam: 'name',
            minChars: 3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('ADMISSION_STATUS'),
            name: 'admissionstatus',
            itemId: 'admissionStatusModuleResults',
            editable: false,
            store: Ext.create('Academia.store.common.AdmissionStatusStore'),
            valueField: 'name',
            displayField: 'value'
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'datefield',
            name: 'fromDate',
            itemId: 'fromDateModuleResults',
            vtype: 'daterange',
            endDateField: 'toDateModuleResults',
            maxValue: new Date(),
            fieldLabel: getCommonTranslation('FROM_DATE'),
            editable: false,
            listeners: {
                render: function (field) {
                    return dateFormatRender(field);
                }
            }
        }, {
            xtype: 'datefield',
            name: 'toDate',
            itemId: 'toDateModuleResults',
            vtype: 'daterange',
            startDateField: 'fromDateModuleResults',
            maxValue: new Date(),
            fieldLabel: getCommonTranslation('TILL_DATE'),
            editable: false,
            listeners: {
                render: function (field) {
                    return dateFormatRender(field);
                }
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('INTAKE_YEAR'),
            name: 'intakeYear',
            itemId: 'intakeYearModuleResults',
            displayField: 'value',
            valueField: 'id',
            allowBlank: false,
            forceSelection: true,
            queryParam: 'qry',
            minChars: 3,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            listeners: {
                render: function (combo) {
                    var store = Ext.create('Academia.store.common.BatchIntakeYearStoreByDTEF');  
                    combo.bindStore(store);    
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
            xtype: 'customcombobox',
            name: 'studentNameSearch',
            itemId: 'studentFieldItemIdModuleResults',
            store: 'reports.admission.dtefModuleResults.StudentNameStore',
            fieldLabel: getCommonTranslation('ADMISSIONCODE_STUDENTNAME_STUDENTCODE'),
            width: 537,
            valueField: 'id',
            displayField: 'value',
            queryParam: 'name',
            minChars: 3,
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            typeAhead: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection: true,
            allowBlank: true,
            matchFieldWidth: true,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code} / {value}' +
                        '</div>';
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'periodResult',
            itemId: 'periodResultIdModuleResults',
            fieldLabel: getCommonTranslation('PERIOD_RESULT'),
            store: Ext.create('Academia.store.reports.admission.dtefModuleResults.PeriodResultStore'),
            valueField: 'id',
            displayField: 'id',
            forceSelection: true,
            editable: false,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.maxWidth = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [ {
            xtype: 'customcombobox',
            name: 'nationalId',
            itemId: 'nationalIdItemIdModuleResults',
            store: 'reports.admission.dtefModuleResults.NationalIdStore',
            fieldLabel: getCommonTranslation('NATIONAL_ID'),
            valueField: 'id',
            displayField: 'id',
            queryParam: 'name',
            minChars: 3,
            triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
            typeAhead: false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection: true,
            allowBlank: true,
            matchFieldWidth: true,
            listConfig: {
                listeners: {
                    beforeshow: function (picker) {
                        picker.minWidth = picker.up('combobox').getSize().width;
                        picker.width = picker.up('combobox').getSize().width;
                    }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function () {
                    return '<div class="search-item">' +
                        '{code} / {value}' +
                        '</div>';
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
		layout: 'hbox',
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            formBind: true,
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetButtonId',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});