/**
 * @author Deepak Sharma
 * 
 */
Ext.define('Academia.view.reports.common.EmployeeAttendancePieChartReport', {
	extend: 'Ext.chart.Chart',
	alias: 'widget.employeeattendancepiechartreport',
	animate: true,
	shadow: true,
	legend: {
		position: 'right'
    },
	insetPadding: 30,
	theme: 'Base:gradients',
	initComponent: function() {
		var this$ = this;
		var numberField = !isNullOrEmpty(this.numericField)?this.numericField:'number';
		var categoryField = !isNullOrEmpty(this.categoryField)?this.categoryField:'category';
		
		
		
		var chartStore = null;
		if(!isNullOrEmpty(this.store)){
			chartStore = Ext.create(this.store);
		}else{
			chartStore = Ext.create('Ext.data.JsonStore',{
				fields: ['number', 'category'],
				data: [{
					number :0,
					category : 'Category'
				}]
			});
		}
		Ext.apply(this$, {
			store: chartStore,
			series: [{
				type: 'pie',
				field: numberField,
				showInLegend: true,
				donut: false,				
				colorSet:['#538234', '#FE0000' , '#FFC000'],
				getLegendColor: function(index) {
					return ['#538234', '#FE0000' , '#FFC000'][index];
				},
				tips: {
					trackMouse: true,
					//width: 300,
					height: 28,
					layout: 'fit',
					renderer: function(storeItem, item) {
						var total = 0;
						chartStore.each(function(rec) {
							total += rec.get(numberField);
						});
						var tipTitle = storeItem.get(categoryField) + ': ' + storeItem.get(numberField);
						var length = (tipTitle.length)* 10;
						this.setWidth(length);
						this.setTitle(tipTitle);
					}
				},
				highlight: {
					segment: {
						margin: 20
					}
				},
				label: {
					field: categoryField,
					display: 'rotate',
					contrast: true,
					font: '15px Arial',
					renderer: function(value, label, storeItem, item, i, display, animate, index) {
						var text;
						if (typeof storeItem.get(numberField) !== 'undefined' ||  storeItem.get(numberField) != null) {
							if(storeItem.get(numberField) == 0){
								text = '';
							}else{
								if( typeof storeItem.get("Present") !== 'undefined'){
									text = storeItem.get("Present")+ '%' ;
									if(text.length > 12){
										text = text.substring(0, 10) + '..';
									}
								}
								else{
									text = '';
								}
							}

						}else{
							text = '';
						}
						label.setAttributes({
							text: text
						}, true);
						return text;
					}
				}
			}]
		});

		this$.callParent(arguments);
	}
});