/**
 * This is used for pie chart report
 * @author Swapnil.patil
 */
Ext.define('Academia.view.reports.common.PieChartAdvanceReport', {
    extend: 'Ext.chart.Chart',
    alias: 'widget.piechartadvancereport',
    animate: true,
    shadow: true,
    legend : {
		/* visible:true,
		spacingOffset : 5,
		 itemSpacing: 5,
		 //padding: 100,
		 boxZIndex: 20,
		 */ position: 'right'
	},
	
    //insetPadding: 30,
   // theme: 'Base:gradients',
    initComponent: function() {
        var this$ = this;
        var numberField = !isNullOrEmpty(this.numericField)?this.numericField:'number';
        var categoryField = !isNullOrEmpty(this.categoryField)?this.categoryField:'category';
        var showLegend = (!isNullOrEmpty(this.legendField)&& this.legendField)?true:false;
        var chartStore = null;
        if(!isNullOrEmpty(this.store)){
        	chartStore = Ext.create(this.store);
        }else{
        	chartStore = Ext.create('Ext.data.JsonStore',{
        		fields: ['number', 'category'],
        		data: [{
        			number :0,
        			category : 'Category'
        		}]
        	});
        }
        Ext.apply(this$, {
        	store: chartStore,
        	series: [{
                type: 'pie',
                field: numberField,
                showInLegend: true,
                   donut:false,
                tips: {
                    trackMouse: true,
                    width: 300,
                    height: 28,
                    layout: 'fit',
                    donut:false,
                    renderer: function(storeItem, item) {
                    	var total = 0;
                        chartStore.each(function(rec) {
                            total += rec.get(numberField);
                        });
                      var tipTitle = storeItem.get(categoryField) + ': ' + storeItem.get(numberField);
                      var length = (tipTitle.length)* 10;
                	  this.setWidth(length);
                  	  this.setTitle(tipTitle);
                    }
                },
                highlight: {
                  segment: {
                    margin: 20
                  }
                },
                label: {
                    field: categoryField,
                    display: 'rotate',
                    contrast: true,
                    font: '15px Arial',
                    renderer: function(value, label, storeItem, item, i, display, animate, index) {
                    	var text;
                    	if(storeItem.get(numberField)!= undefined ||  storeItem.get(numberField)!= null){
                    		if(storeItem.get(numberField) == 0){
                    			text = '';
                    		}else{
                    			text =  '('+storeItem.get(numberField)+')';
                    		}
                    		
                    	}else{
                    		text = value;
                    	}
                    	label.setAttributes({
                            text: text
                        }, true);
                        return text;
                    }
                }
            }]
        });

        this$.callParent(arguments);
    }
});