/**
 * This view is used for student count of request
 * @author Sachin.Bangar
 */

Ext.define('Academia.view.reports.complaints.ComplaintsClosureRateView', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.complaintsclosurerateview',
    title: getServiceRequestTranslation('GRIEVANCE_CLOSURE_RATE'),
    cls: 'panelNoSpace',
    autoScroll: true,
    items: [{
        xtype: 'complaintsclosureratesearch',
        itemId: 'complaintsClosureRateSearch'
    }, {
    	xtype: 'form',
    	frame: true,
    	items:[{
            xtype: 'columnchartreport',
            itemId: 'complaintsClosureRateChart',
            width: 800,
            minHeight: 500,
            maxHeight: 1000,
            columnWidth: 50,
            columnColor: 'orange',
            store: 'Academia.store.reports.servicerequest.RequestClosureRateStore',
            xAxesNumericField: 'count',
            xAxesNumericTitle: getServiceRequestTranslation('NUMBER_OF_REQUEST'),
            yAxesCategoryField: 'property',
            yAxesCategoryTitle: getServiceRequestTranslation('CLOSED_IN_DAYS')
        }]
    }]
});