/**
 * This view is used for unassigned complaint 
 * @author Sachin.Bangar
 */

Ext.define('Academia.view.reports.complaints.UnassignedComplaintReportView', {
    extend: 'Ext.form.FormPanel',
    alias: 'widget.unassignedcomplaintreportview',
    frame: true,
    cls: 'panelNoSpace unassignedComplaint',
    autoScroll: false,
    style:{
		'margin-left':'-50px !important'
	},
    items: [{
        xtype: 'form',
        itemId: 'unassignedComplaintSearchForm',
        frame: true,
        plugins: "formlabelrequired",
        cls: 'customSearchPanel',
        items:[{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            items: [{
                xtype: 'customcombobox',
                name: 'complaintTypeId',
                itemId: 'complaintTypeField',
                fieldLabel: getServiceRequestTranslation('GRIEVANCE_TYPE'),
                displayField: 'value',
                valueField: 'id',
                autoload: false,
                editable: false,
                listeners: {
                    render: function(combo) {
                        var store = Ext.create('Academia.store.servicerequest.complaintrequest.ComplaintTypes');
                        combo.bindStore(store);
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
        	cls: 'customSearchPanelBtnsFieldContainerCls',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'searchButtonId',
                //buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }, {
                xtype: 'button',
                text: getCommonTranslation('RESET'),
                itemId: 'resetButtonId',
                //buttonAlign: 'right',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
    }, {
    	xtype:'panel',
    	items:[{
        	xtype: 'unassignedcomplaintgrid',
        	itemId: 'unassignedComplaintReportGrid'
        }]
    }]
});