/**
 * @author Raghavendra.Soni
 */
Ext.define('Academia.view.reports.completion.CompletionReportSearch',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.completionreportsearch',  
	method : 'POST',
	standardSubmit : false,
	frame:false,
	cls:'customSearchPanel',
	plugins : "formlabelrequired",
	items: [{
    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
		items :[{
			xtype: 'customcombobox',
			width: 536,
			name: 'academyLocationFilter',
			itemId: 'academyLocationFilter_ItemId',
			fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
			store: Ext.create('Academia.store.common.AcademyLocationNameSeparated'),
			displayField:'value',
			valueField:'id',
			autoloadStore: false,
			allowBlank:false,
			queryParam:'qry',
			minChars:3,
			typeAhead:false,
			labelAlign: 'top',
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			}
		}]
	},{
		xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items:[{
        	xtype: 'customcombobox',
        	name:'programId',
        	itemId:'programId_ItemId',
        	fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
        	store: Ext.create('Academia.store.common.ProgramsByAcademyIdLocationId'),
        	displayField:'valueCode',
        	valueField:'id',
        	typeAhead:true,
        	forceSelection:true,
        	hideTrigger:false,
        	triggerAction: 'all',
        	minChars:3,
        	queryParam:'qry',
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{value}'  +
        			'</div>';
        		}
        	}
        },{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId:'batchId_ItemId',
			store: Ext.create('Academia.store.common.BatchesByProgramId'),
			displayField:'value',
			valueField:'id',
			disabled:true,
			typeAhead:true,
			fieldLabel:getExaminationTranslation('BATCH')
		}]
	},{
        xtype: 'fieldcontainer',
        width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'quickSearchId_ItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind:true,
            style: 'margin-left:0 !important;'
        },{
        	xtype: 'button',
			itemId: 'resetBtn_ItemId',
			text: getCommonTranslation('RESET'),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});