/**
 * This view is used for faculty closure reason 
 * @author Pravin.Surve
 */

Ext.define('Academia.view.reports.faculty.FacultyClosureReasonView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.facultyclosurereasonview',
    title: getServiceRequestTranslation('CLOSURE_REASON'),
    cls: 'panelNoSpace',
    autoScroll: true,
    items: [{
        xtype: 'facultydashboardcommonsearchform',
        itemId: 'facultyClosureReasonSearch'
    }, {
    	xtype: 'form',
    	frame: true,
    	items:[{
            xtype: 'barchartreport',
            itemId: 'facultyClosureReasonChart',
            minWidth: 700,
            height: 500,
            columnHeight: 30,
            columnColor: 'orange',
            store: 'Academia.store.reports.servicerequest.ClosureReasonGraphStore',
            xAxesNumericField: 'count',
            xAxesNumericTitle: getServiceRequestTranslation('COUNT_OF_REQUEST'),
            yAxesCategoryField: 'property',
            yAxesCategoryTitle: getServiceRequestTranslation('CLOSURE_REASON')
        }]
    }]
});