/**
 * @author Pritam.Patil
 * This view is used for the Faculty Unassigned Request quick search form
 */
Ext.define('Academia.view.reports.faculty.FacultyUnassignedRequestSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.facultyunassignedrequestsearchform',
    cls: 'customSearchPanel',
    defaults: {
        labelAlign: 'top'
    },
    frame: true,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'requestsubrequesttypefieldcontainer',
        itemId: 'requestTypeFieldContainer',
        layout: 'hbox'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'livesearchcombo',
            name: 'requesterId',
            fieldLabel: getPersonModuleTranslation('REQUESTER_NAME'),
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            itemId: 'requesterNameId' ,
     		listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.servicerequest.complaintrequest.ComplaintPersons');
                    store.getProxy().api.read = SERVERURL.COMPLAINT_FACULTY_COMBO;
                    combo.bindStore(store);
                }
            },
            displayTpl: new Ext.XTemplate('<tpl for="."between=" ">',
             		'{[typeof values === "string" ? values : values["value"]]}' +
             		'</tpl>'
             		)
             		
             		
        },{
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('DEPARTMENT'),
            queryMode:'local',
            editable: false,
            name: 'departmentId',
            itemId: 'departmentCombo',
            valueField: 'id',
            displayField: 'value',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.department.DepartmentAcademyLocationWiseStore');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('SUB_DEPARTMENT'),
            
            editable: false,
            queryMode: 'local',
            name: 'subDepartmentId',
            itemId: 'subDepartmentCombo',
            valueField: 'id',
            displayField: 'name',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.department.SubDepartmentComboStore');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
    	cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            //buttonAlign: 'left',
            disabled: true,
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetButtonId',
            //buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});