/**
 * Dharmendra.p
 */
Ext.define('Academia.view.reports.programcourse.creditbasedreport.CreditBasedSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.creditbasedsearch',  
	plugins : "formlabelrequired",
    autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    items: [{
    	xtype : 'fieldcontainer',
    	layout : {
    		type : 'hbox'
    	},
    	defaults : {
    		width: 256,
    		labelAlign : 'top'
    	},
    	items : [{
		xtype: 'multiselectcombofield',
		width: 46,
	//	height:58,
		cls:'receiptHeaderMultiselect resetPasswordMultiselect',
		name: 'multiselectAcademyLocation',
		itemId: 'multiselectAcademyLocationId',
		allowBlank : false,
		fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
		store:'common.AcademyLocationNameSeparated',
		displayField:'value',
		/*style :{
			  marginLeft: '6px'
		},*/
		editable:false,
		valueField:'id',
		maxLength:15000,
		autoloadStore: false,
//		queryMode:'local'
	}
    	]},{
    	xtype : 'radiogroup',
    	labelAlign : 'top',
        name:'programPeriodLevelId',
		itemId:'programPeriodLevelId',
		fieldLabel : getProgramandcourseTranslation('DEGREE_OF_REPORT'),
		 defaults: {
    		 flex: 1
    	 },
    	 items: [{
    		 boxLabel  : getProgramandcourseTranslation('PROGRAM_LEVEL'),
    		 name      : 'creditLevel',
    		 inputValue: 'PROGRAM',
    		 checked   : true
    	 },{
    		 boxLabel  : getProgramandcourseTranslation('PERIOD_LEVEL'),
    		 name      : 'creditLevel',
    		 inputValue: 'PERIOD'		                     
    	 }]
    },{
    	xtype : 'fieldcontainer',
    	layout : {
    		type : 'hbox'
    	},
    	defaults : {
    		width: 256,
    		labelAlign : 'top'
    	},
    	items : [{
			xtype: 'customcombobox',
			name:'admissionId',
			itemId:'admissionStudentId',
			store:'reports.programcourse.creditbasedreport.AdmissionStudentByAcademyLocation',
			fieldLabel:getExaminationTranslation('ADMISSION_CODE_STD_NAME_STD_CODE'),
			width:400,  
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'term',
			minChars:3,
			typeAhead:false,
            hideTrigger:true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            triggerAction: '',
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.maxWidth = picker.up('combobox').getSize().width; 
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'), 
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code} / {value}'  +
	                    '</div>';
	                }
	            }
		}]},{
    		xtype : 'fieldcontainer',
    		defaults : {
    			width: 256,
    			labelAlign : 'top'
    		},
    		layout : {
    			type : 'hbox'
    		},
    		items : [{
    			xtype : 'customcombobox',
    			fieldLabel : getCommonTranslation('PROGRAM_CODE_OR_NAME'),						
    			name : 'program',
    			itemId : 'programId',
    			store : 'common.ProgramsByAcademyLocationsIds',
//    			store : 'examinationcenters.reports.ExaminationCreditBaseReportProgramStore',
    			displayField : 'valueCode',
    			valueField : 'id',
    			disabled:true,
    			allowBlank:false,
    			queryParam:'programName',
    			minChars:3,
				typeAhead:false,
				triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
				enableKeyEvents  : 'true',
				hideTrigger:false,
				forceSelection:true,
				allowBlank:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
    		},{
    			xtype: 'customcombobox',
    			name: 'batch',
    			itemId:'batchId',
    			fieldLabel : getProgramandcourseTranslation('BATCH'),
    			store: 'enquiry.AcademicBatchStore',
    			valueField: 'id',
    			displayField: 'value',
    			typeAhead:true,
    			disabled:true,
    			forceSelection:true,
    			allowBlank:false,
    		}]
    	},{
    		xtype: 'fieldcontainer',
    		layout: 'hbox',
    		itemId:'periodLevel',
    		hidden:true,
    		defaults: {
    			width: 256,
    			labelAlign: 'top'
    		},
    		items :[{
    			xtype: 'customcombobox',
    			fieldLabel: getCourseTxCommonTranslation('PERIOD'),
    			name:'period',
    			itemId: 'periodId',
    			store:'program.programDetails.programBatches.courseParameter.ProgramCoursePeriod',
    			displayField: 'value',
    			valueField: 'id',
    			typeAhead:true,
    			forceSelection:true,
    			allowBlank:false,
    			disabled:true
    		},{
				xtype : 'customcombobox',
				fieldLabel : getCourseTxCommonTranslation('SECTION'),
				name : 'section',
				itemId : 'sectionId',
				store:'attendance.SectionAndFacultyByPeriodID',
				displayField : 'sectionCode',
				valueField : 'sectionId',
				forceSelection:true, // V2D-444759 
				disabled:true
			}]
    	},{
            xtype: 'fieldcontainer',
            width: 'auto',
    		layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SEARCH'),
                itemId: 'searchBtn',
                //buttonAlign: 'left',
                ui: 'CustomBtnSubmit',
                formBind:true,
                scale: CONSTANTS.BUTTONSIZE,
                margin: '0 44 0 0'
            },{
                xtype: 'button',
                text: getCourseTxCommonTranslation('RESET'),
                itemId: 'resetBtn',
                //buttonAlign: 'left',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE
            }]
        }]
});