/**
 * Akshay Sharma
 */
Ext.define('Academia.view.reports.programcourse.specialization.SpecializationReportSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.specializationreportsearch',  
	plugins : "formlabelrequired",
    autoScroll: true,
    frame: false,
	cls:'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    items: [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items :[{
        		xtype: 'customcombobox',
        		name: 'program',
        		width: 536,
        		itemId: 'programId',
        		fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
//        		translationKey:'PROGRAM',
        		store:'common.ProgramStore',
        		displayField:'valueCode',
        		valueField:'id',
        		allowBlank:true,
        		queryParam:'programName',
				minChars:3,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
        	},{
    			xtype: 'customcombobox',
    			name: 'batchId',
    			fieldLabel: getCourseTxCommonTranslation('BATCH'),
    			itemId:'batchId',
    			store: 'enquiry.AcademicBatchStore',
    			valueField: 'id',
    			displayField: 'value',
    			disabled:true,
    			allowBlank:true,
    			typeAhead:true,
    			forceSelection:true
    		}]
        },
        {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items :[{
        		xtype: 'customcombobox',
        		name: 'batchSpecialization',
        		width: 536,
        		itemId: 'batchSpecializationId',
        		fieldLabel: getProgramandcourseTranslation('BATCH_SPECIALIZATION'),
        		store:'program.programDetails.programBatches.courseSpecialization.ProgramCourseSpecializationStoreGrid',
        		displayField:'specializationName',
        		valueField:'specializationId',
        		disabled:true,
        		allowBlank:true,
        		typeAhead:true,
        		forceSelection:true 

        	}]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items :[{
	        	 xtype: 'customcombobox',
	        	 name:'studentId',
	        	 itemId:'studentId_itemId',
	        	 store: 'attendance.StudentSearch',
	        	 fieldLabel : getProgramandcourseTranslation('ADMISSION_CODE'),
	        	 valueField: 'value',
	        	 displayField: 'value',
	        	 queryParam:'code',
	        	 minChars:3,
	        	 typeAhead:false,
	        	 triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	        	 enableKeyEvents  : 'true',
	        	 hideTrigger:false,
	        	 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        	 triggerAction: '',
	        	 forceSelection:true,
	        	 listConfig: {
	        		 listeners: {
	 					beforeshow: function(picker) {
	 						picker.minWidth = picker.up('combobox').getSize().width;
	 					}
	 				},
	        		 loadingText: getCommonTranslation('SEARCHING'),
	        		 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        		 getInnerTpl: function() {
	        			 return '<div class="search-item">' +
	        			 '{value}' +
	        			 '</div>';
	        		 }
	        	 }

	         },{
	        	 xtype: 'customcombobox',
	        	 name:'studentName',
	        	 itemId:'studentName_itemId',
	        	 store: 'coursetransaction.studentenrollment.studentenrollmentdetail.StudentNameBySmartSearch',
	        	 fieldLabel:getCourseTxCommonTranslation('STUDENT_NAME'),
	        	 valueField: 'value',
	        	 displayField: 'value',
	        	 queryParam:'name',
	        	 minChars:3,
	        	 typeAhead:false,
	        	 triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
	        	 enableKeyEvents  : 'true',
	        	 hideTrigger:false,
	        	 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	        	 triggerAction: '',
	        	 forceSelection:true,
	        	 listConfig: {
	        		 listeners: {
	 					beforeshow: function(picker) {
	 						picker.minWidth = picker.up('combobox').getSize().width;
	 					}
	 				},
	        		 loadingText: getCommonTranslation('SEARCHING'),
	        		 emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	        		 getInnerTpl: function() {
	        			 return '<div class="search-item">' +
	        			 '{value}' +
	        			 '</div>';
	        		 }
	        	 }
	         }]
            },{
        	xtype: 'fieldcontainer',
        	width: 'auto',
    		layout : {
    			type : 'hbox'
    		},
    		cls: 'customSearchPanelBtnsFieldContainerCls',
        	items: [{
        		xtype: 'button',
        		text: getCommonTranslation('SEARCH'),
        		itemId: 'searchBtn',
        		buttonAlign: 'left',
        		ui: 'CustomBtnSubmit',
        		formBind:true,
        		scale: CONSTANTS.BUTTONSIZE,
        		margin: '0 36 0 0'
        	},{
        		xtype: 'button',
        		text: getCourseTxCommonTranslation('RESET'),
        		itemId: 'resetBtn',
        		buttonAlign: 'left',
        		ui: 'CustomBtnCancel',
        		scale: CONSTANTS.BUTTONSIZE
        	}]
        }]
    	//}]
});