/**
 *  This grid is used for unassigned student/faculty request
 *  @author Sachin.Bangar
 */
Ext.define('Academia.view.reports.servicerequest.UnassignedRequestReportGrid', {
	// extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.unassignedrequestreportgrid',
	title: getServiceRequestTranslation('UNASSIGNED_REQUESTS'),
	border: true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	columns: [{
		header: getServiceRequestTranslation('REQUEST_ID'),
		dataIndex: 'requestId',
		sortable: true,
		flex: .2,
		renderer: function(value){
			return '<a href="#">'+ value +'</a>';
		}
	}, {
		header: getServiceRequestTranslation('REQUEST_CATEGORY'),
		dataIndex: 'requestType',
		sortable: true,
		flex: .2,
		renderer: function(value){
			if(value!=null){
				return	getServiceRequestTranslation(value);
			}
			else
				return value;
		}
	}, {
		header: getServiceRequestTranslation('REQUEST_TYPE'),
		dataIndex: 'subRequestType',
		sortable: true,
		flex: .2
	}, {
		header: getServiceRequestTranslation('REQUESTER_NAME'),
		dataIndex: 'requesterName',
		sortable: true,
		flex: .2
	}, {
		header: getServiceRequestTranslation('REQUEST_DATE'),
		dataIndex: 'requestDate',
		sortable: true,
		flex: .2,
		renderer:function(value) {
			return dateRender(value);
		}
	}, {
		header: getServiceRequestTranslation('REQUEST_ASSIGNED_TO'),
		dataIndex: 'assignRequest',
		sortable: true,
		flex: .2,
		renderer: function(value){
			return '<a href="#">'+ getServiceRequestTranslation('ASSIGN_REQUEST') +'</a>';
		}
	}],
	/* initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
 },*/
	initComponent: function() {
		var this$ = this;
		var store = this$.buildStore();
		Ext.apply(this$, {
			store: store,
			dockedItems: [{
				xtype: 'toolbar',
				dock: 'bottom',
				items: [{
					xtype: 'custompagingtoolbar',
					plugins: ['pagesize'],
					store: store,
					emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
					displayInfo: true
				}]
			}]
		});

		this$.addExportToolBarItems(this$);
		this$.callParent(arguments);
	},
	buildStore: function() {
		return Ext.create('Academia.store.reports.servicerequest.UnassignedRequestStore');
	}
});