/**
 * This view is used for Service request sub request type search form
 *  * @author Sachin.Bangar
 */
Ext.define('Academia.view.reports.student.RequestSubRequestTypeFieldContainer', {
    extend: 'Ext.form.FieldContainer',
    alias: 'widget.requestsubrequesttypefieldcontainer',
    defaults: {
        labelAlign: 'top',
        width: 256,
       
    },
    items: [{
        xtype: 'customcombobox',
        name: 'SERVICE_REQUEST_GROUP',
        fieldLabel: getServiceRequestTranslation('REQUEST_CATEGORY'),
        itemId: 'requestTypeField',
        displayField: 'name',
        valueField: 'value',
        editable: false,
       listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.servicerequest.ServiceRequestCategory');
                combo.bindStore(store);
            }
        }
    }, {
        xtype: 'customcombobox',
        name: 'REQUEST_TYPE_ID',
        fieldLabel: getServiceRequestTranslation('REQUEST_TYPE'),
        itemId: 'requestSubCategoryField',
        displayField: 'value',
        valueField: 'id',
        queryMode: 'local',
        editable: false,
        hidden:true,
        listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.reports.servicerequest.ServiceRequestSubCategoryStore');
                combo.bindStore(store);
            }
        }
    }, {
    	xtype: 'livesearchcombo',
    	itemId: 'assigneeCombo',
    	store: 'Academia.store.reports.servicerequest.SystemUsersByAcademyLocationIds',
    	hidden: false,
    	fieldLabel: getServiceRequestTranslation('REQUEST_ASSIGNED_TO'),
    	name: 'assignTo',
		emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			},
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
		}
    },{
        xtype: 'customcombobox',
        name: 'CERTIFICATE_CATEGORY',
        fieldLabel: getServiceRequestTranslation('CERTIFICATE_CATEGORY'),
        itemId: 'certificateCategoryField',
        displayField: 'name',
        valueField: 'value',
        queryMode: 'local',
        hidden: true,
        editable: false,
        listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.servicerequest.servicerequestsettings.CertificateCategories');
                combo.bindStore(store);
            }
        }
    }, {
        xtype: 'customcombobox',
        name: 'CERTIFICATE_ID',
        fieldLabel: getServiceRequestTranslation('CERTIFICATE_TYPES'),
        itemId: 'certificateSubCategoryField',
        displayField: 'value',
        valueField: 'id',
        queryMode: 'local',
        hidden: true,
        editable: false,
        listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.reports.servicerequest.CertificateSubCategoryStore');
                combo.bindStore(store);
            }
        }
    }, {
        xtype: 'customcombobox',
        name: 'FREE_FORM_REQUEST_CATEGORY',
        fieldLabel: getServiceRequestTranslation('FREE_FORM_CATEGORY'),
        itemId: 'freeFormCategoryField',
        displayField: 'value',
        valueField: 'id',
        queryMode: 'local',
        hidden: true,
        editable: false,
        listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.reports.servicerequest.FreeFormCategoryStore');
                combo.bindStore(store);
            }
        }
    }, {
        xtype: 'customcombobox',
        name: 'FREE_FORM_REQUEST_ID',
        fieldLabel: getServiceRequestTranslation('FREE_FORM_REQUEST'),
        itemId: 'freeFormSubCategoryField',
        displayField: 'value',
        valueField: 'id',
        queryMode: 'local',
        hidden: true,
        editable: false,
        listeners: {
            render: function(combo) {
                var store = Ext.create('Academia.store.reports.servicerequest.FreeFormSubCategoryStore');
                combo.bindStore(store);
                
                store = combo.getStore();
                store.on('load', function () {
                	var parent = combo.up('studenttrackrequesttabpanel');
                	if(parent){
                		combo.displayField = 'valueStatus';
                        combo.tpl = Ext.create('Ext.XTemplate',
                            '<tpl for=".">',
                                '<div class="x-boundlist-item">{' + combo.displayField + '}</div>',
                            '</tpl>'
                        );

                        if (combo.getPicker && combo.getPicker().refresh) {
                            combo.getPicker().refresh();
                        }

                        if (combo.getDisplayValue) {
                            combo.setRawValue(combo.getDisplayValue());
                        }
                	}
                });
            }
        }
    },{
		xtype: 'checkboxfield',
		labelAlign: 'right',
		style:{
			marginLeft:'8px',
			marginTop:'25px'
		},
		boxLabel: getCommonTranslation('AUTO_FOLLOWUP'),
		name: 'autoFollowupCheck',
		itemId:'autoFollowupCheck',
		inputValue: true
	}]
    
});