/**
 * This view is used for student closure reason 
 * @author Sachin.Bangar
 */

Ext.define('Academia.view.reports.student.StudentClosureReasonView', {
	extend:'Ext.form.FormPanel',
    alias: 'widget.studentclosurereasonview',
    title: getServiceRequestTranslation('CLOSURE_REASON'),
    cls: 'panelNoSpace',
    autoScroll: false,
    items: [{
        xtype: 'requestclosureratesearchform',
        itemId: 'studentClosureReasonSearch'
    }, {
    	xtype: 'form',
    	frame: true,
    	items:[{
            xtype: 'barchartreport',
            itemId: 'studentClosureReasonChart',
            minWidth: 700,
            minHeight: 200,
			maxHeight: 1000,
            height: 500,
            columnHeight: 30,
            columnColor: 'orange',
            store: 'Academia.store.reports.servicerequest.ClosureReasonGraphStore',
            xAxesNumericField: 'count',
            xAxesNumericTitle: getServiceRequestTranslation('COUNT_OF_REQUEST'),
            yAxesCategoryField: 'property',
            yAxesCategoryTitle: getServiceRequestTranslation('CLOSURE_REASON')
        }]
    }]
});