/**
 * This view is used for the Certificate report quick search form.
 * @author Trupti.Paoneker
 */
Ext.define('Academia.view.reports.student.personaldetail.ChildrenOfEmployeeQuickSearchForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.childrenofemployeequicksearchform',
    frame: false,
    cls:'customSearchPanel', 
    height: '30%',
    //layout: 'vbox',
    standardSubmit: false,
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('ADMISSION_NUMBER'),
            name: 'ADMISSION_CODE'
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('STUDENT_ID'),
            name: 'STUDENT_CODE'

        }, {
            xtype: 'customcombobox',
            name: 'PROGRAM_ID',
            itemId: 'program',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
         // editable: false,
            valueField: 'id',
            displayField: 'valueCode',
            queryParam:'programName',
            allowBlank: true,
            minChars:3,
			typeAhead:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.ProgramByAcAndLoIdStore');
                    combo.bindStore(store);
                }
            },
            listConfig: {
                listeners: {
                    beforeshow: function(picker) {
                    picker.minWidth = picker.up('combobox').getSize().width;
                    }
                   },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function() {
                    return '<div class="search-item">' +
                   '{code} / {value}'+
                   '</div>';
                    }
                 }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'BATCH_ID',
            itemId: 'batch',
            fieldLabel: getPersonModuleTranslation('BATCH'),
            editable: false,
            displayField: 'value',
            valueField: 'id',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'COURSE_ID',
            itemId: 'course',
            fieldLabel: getCommonTranslation('COURSE_CODE_NAME'),
//            editable: false,
            valueField: 'courseId',
            displayField: 'courseName',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.admission.applications.admissionAndMidTermAdmission.MidTermAdmMainCourseGridStore');
                    combo.bindStore(store);
                }
            },
			queryParam:'qry',
			minChars:3,
			allowBlank: true,
			typeAhead:false,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{value}' +
	                    '</div>';
	                }
	            }
        }, {
            xtype: 'customcombobox',
            name: 'SECTION_ID',
            itemId: 'section',
            fieldLabel: getPersonModuleTranslation('SECTION'),
            editable: false,
            valueField: 'id',
            displayField: 'value',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionMultiSelect');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('SELECT_NAME'),
            store: 'common.SelectNameComboStore',
            editable: false,
            queryMode: 'local',
            name: 'selectedNameField',
            itemId: 'selectedNameField',
            valueField: 'id',
            displayField: 'value',
            value: 'FIRST_NAME'
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
            itemId: 'selectedName',
            name: 'FIRST_NAME'
        }, {
            xtype: 'textfield',
            fieldLabel: getServiceRequestTranslation('EMPLOYEE_ID'),
            name: 'EMPLOYEE_ID',
            itemId: 'EmployeeId',
            labelAlign: 'top',
            width: 256
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('SELECT_EMPLOYEE_NAME'),
            store: 'common.picklist.SelectEmployeeNameComboStore',
            editable: false,
            queryMode: 'local',
            name: 'selectedEmployeeNameField',
            itemId: 'selectedEmployeeNameField',
            valueField: 'id',
            displayField: 'value',
            value: 'EMPLOYEE_FIRST_NAME'
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
            itemId: 'selectedEmployeeName',
            name: 'EMPLOYEE_FIRST_NAME'
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
		layout : {
			type : 'hbox'
		},
		cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        },{
            xtype: 'button',
            text: getCommonTranslation('CLEAR_SEARCH'),
            itemId: 'clearSearchBtn',
            buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]

    }]

});