/**
 * This view is used for the Follow Up Scheduled report quick search form.
 * @author Trupti.Paoneker
 */
Ext.define('Academia.view.reports.student.serviceDetailReportformQuickSearchform', {
    extend: 'Ext.form.Panel',
    alias: 'widget.serviceDetailReportformQuickSearchform',
    frame: false,
    cls:'customSearchPanel',
    plugins: "formlabelrequired",
    items: [{
				xtype: 'customcombobox',
				name: 'requestId',
				layout:'hbox',
				fieldLabel: getServiceRequestTranslation('REQUEST_ID'),
				store: 'servicerequest.studentservicerequest.StudentRequestStore',
				itemId: 'request_id',
		        msgTarget: 'qtip',
				valueField: 'code',
				displayField: 'code',
				queryParam:'serviceRequestNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				labelAlign: 'top',
				width: 256,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
            	
        },{
        xtype: 'serviceDetailReportRequestCategoryFieldContainer',
        itemId: 'requestTypeFieldContainer',
        layout: 'hbox'
    }, {
        xtype: 'fieldcontainer',
        itemId: 'progrmBatchSectionContainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'customcombobox',
            name: 'programId',
            itemId: 'programComboField',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            
            displayField: 'valueCode',
            valueField: 'id',
           // queryMode: 'local',
            queryParam:'qry',
            //  autoload: false,
              allowBlank: true,
  			minChars:3,
  			typeAhead:false,
              emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
              forceSelection:true,
            
             listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.ProgramsByAcademyIdLocationId');
                    combo.bindStore(store);
                }
            },
            listConfig: {
                listeners: {
                beforeshow: function(picker) {
                  picker.minWidth = picker.up('combobox').getSize().width;
                  }
                },
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                  return '<div class="search-item">' +
                  '{code} / {value}'+
                  '</div>';
                  }
                }
        }, {
            xtype: 'customcombobox',
            name: 'batchId',
            itemId: 'batchComboField',
            fieldLabel: getCommonTranslation('BATCH'),
            
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.common.BatchesByProgramId');
                    combo.bindStore(store);
                }
            }
        }, {
            xtype: 'customcombobox',
            name: 'sectionId',
            itemId: 'sectionComboField',
            fieldLabel: getCommonTranslation('SECTION'),
            
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            autoload: false,
            width: 256,
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.coursetransaction.sectionmanagement.SectionMultiSelect');
                    combo.bindStore(store);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
        	labelAlign: 'top',
            width: 256
        },
        items: [{
            xtype: 'datefield',
            itemId: 'startDate',
            fieldLabel: getServiceRequestTranslation('FROM_DATE'),
            name: 'startDate',
            vtype: 'daterange',
            endDateField: 'endDate',
            maxValue : new Date(),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            
            editable: false
        }, {
            xtype: 'datefield',
            name: 'endDate',
            itemId : 'endDate',
            fieldLabel: getServiceRequestTranslation('TO_DATE'),
            vtype: 'daterange',
            startDateField: 'startDate',
            maxValue : new Date(),
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
    	cls: 'customSearchPanelBtnsFieldContainerCls',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            //buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        }, {
            xtype: 'button',
            text: getCommonTranslation('RESET'),
            itemId: 'resetButtonId',
            //buttonAlign: 'right',
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]

});