/**
 *  @author Deepak Sharma
 */

Ext.define('Academia.view.reports.survey.ParticipantDetailGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.participantdetailgrid',
	store : 'reports.survey.ParticipantDetailGridStore',
	title: getCommonTranslation('PARTICIPANT_INFO'),
	border: true,
	autoScroll: false,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},  
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'reports.survey.ParticipantDetailGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	 initComponent: function() {
         var grid=this;                   
         grid.addExportToolBarItems(grid);
         this.callParent(arguments);     
  },
	
	columns: [{
		header : getCommonTranslation('SURVEY_TITLE'),
		dataIndex : 'surveyTitle',
		flex:1
	},{
		header : getCommonTranslation('PARTICIPANT_NAME'),
		dataIndex : 'participantName',
		flex : 1
	},{
		header : getCommonTranslation('PARTICIPANT_EMAIL'),
		dataIndex : 'participantEmail',
		flex : 1
	},{
		header : getCommonTranslation('SURVEY_SHARE_DATE'),
		dataIndex : 'surveySharedDate',
		flex : 1,
		renderer: function(date) {
			if(!isNullOrEmpty(date)){
				return dateRender(date);
			}
		}
	},{
		header : getCommonTranslation('PARTICIPANT_TYPE'),
		dataIndex : 'userType',
		flex : 1,
		renderer: function(value) {
			if(!isNullOrEmpty(value)){
				return getCommonTranslation(value);
			}
		}
	}]
});
