/**
 * This view is used for the Inactive User Report List.
 * @author Trupti.Paoneker
 */
Ext.define('Academia.view.reports.systemutilization.inactiveusers.InactiveUserReportQuickSearchView', {
    extend: 'Ext.panel.Panel',
    alias: 'widget.inactiveuserreportquicksearchview',
    cls: 'panelNoSpace horizontalScrollingFixed', 
    autoScroll: true,
    defaults:{
    	width:'100%'
    },
    layout:'anchor',
    items: [{
        xtype: 'inactiveuserreportquicksearchform',
        itemId: 'inactiveUserReportQuickSearch'
    }, {
        xtype: 'tabpanel',
        //minWidth: 800,
        plain: true,
        activeTab: 0,
        items: [{
        	title: getCommonTranslation('INACTIVE_USERS'),
        	itemId: 'inactiveUserReportResultGridTab',
        	items:[{
        		xtype: 'searchresultgrid',
                title: getCommonTranslation('INACTIVE_USERS'),
                itemId: 'inactiveUserReportResultGrid'
        	}]
        },{
        	//xtype: 'panel',
        	//autoScroll: false,
        	title: getCommonTranslation('GROUP_AND_MONTH_WISE_SUMMARY'),
        	itemId: 'inactiveusergroupwiseandmonthwisesummary',
        	width: '70%',
        	items:[{
        		xtype: 'groupedbarchart',
        		style :{
        			marginTop : '10px'
        		},
        		minHeight: 400,
        		width: 700,
        		groupGutter : 1,
        		store: 'Academia.store.reports.systemutilization.inactiveusers.InactiveUserByUsageMonthwiseSummaryStore',
        		xAxesCategoryField: 'MONTH',
        		xAxesCategoryTitle: getServiceRequestTranslation('MONTHS'),
        		yAxesNumericField: 'count',
        		yAxesNumericTitle: getServiceRequestTranslation('NUMBER_OF_REQUEST'),
        		groupField: ['Admin','Faculty' ,'Student']
        	}]
        },{
            //xtype: 'panel',
            title: getCommonTranslation('GROUP_WISE_SUMMARY'),
            itemId: 'inactiveusergroupwisesummary',
            width: '70%',
            items: [{
            	xtype: 'columnchartreport',
                itemId: 'groupwisesummaryChart',
                width: 700,
                minHeight: 400,
                columnWidth: 50,
                columnColor: 'orange',
                store: 'Academia.store.reports.systemutilization.inactiveusers.InactiveUserGroupwiseandMonthwiseSummaryStore',
                xAxesNumericField: 'NO_OF_USERS',
                xAxesNumericTitle: getCommonTranslation('NO_OF_USERS'),
                yAxesCategoryField: 'USER_GRP_NAME',
                yAxesCategoryTitle: getServiceRequestTranslation('USER_GROUP_NAME')

            }]
        }]
    }]
});
