/**
 * 
 * @author priyanshi sharma
 */
Ext.define('Academia.view.scholarship.scholarshiplisting.ListOfOnlineDocumentsCerpGrid', {
	extend: 'Ext.grid.Panel',
    alias: 'widget.listofonlinedocumentscerpgrid',
    store : 'scholarships.SPScholarshipListDocumentsGridStore',
    title: getCommonTranslation('LIST_OF_ONLINE_DOCUMENTS'),
    border: true,
    isGridConfigurable: true,
	enableColumnHide: false,
    viewConfig: {
        stripeRows: true
    },
    dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'scholarships.SPScholarshipListDocumentsGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	tbar: [{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH,
	},{
		xtype: 'button',
		itemId: 'uploadBtn',
		text: getCommonTranslation("UPLOAD"),
	}], 
	columns: [{
		header:  getCommonTranslation("DOCUMENT_NAME"),
		dataIndex:'doucumentMasterName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation("DOCUMENT_TYPE"),
		dataIndex:'documentApplicability',
		flex:1,
		sortable:true,
		renderer: function(value, metadata, record) {
			if(!isNullOrEmpty(value)) {
				switch(value) {
				  case 'MANDATORY':
					  return 'Mandatory';
				    break;
				  case 'OPTIONAL':
					  return 'Optional';
					  break;
				  default:
					  break;
				}
			} 
			return value;
		}
	},{
		header:  getCommonTranslation("SUBMISSION_DATE"),
		dataIndex: 'submissionDate',
		flex:1,
		sortable:true,
		renderer: function(value, metadata, record) {
			return dateRender(value);
		}
	},{
		header:  getCommonTranslation("SUBMISSION_MODE"),
		dataIndex: 'submissionMode',
		flex:1,
		sortable:true,
		hidden:true,
	},{
		header:  getCommonTranslation("DOWNLOAD_ATTACHMENT"),
		dataIndex: 'downloadFileName',
		flex:1,
		sortable:true,
		hidden:true,
		renderer:function(value,rec){
			if(!isNullOrEmpty(value)){
				return '<a href="#">'+value+'</a>';
			}
		}
	},{
		header:  getCommonTranslation("UPLOADED_DOCUMENT"),
		dataIndex: 'uploadFileName',
		flex:1,
		sortable:true,
		renderer:function(value,rec){
			if(!isNullOrEmpty(value)){
				return '<a href="#">'+value+'</a>';
			}
		}
	},{
		header:  getCommonTranslation("INSPECTION_DATE"),
		dataIndex: 'inspectionDate',
		flex:1,
//		hidden:true,
		sortable:true,
		renderer: function(value, metadata, record) {
			return dateRender(value);
		}
	},{
		header:  getCommonTranslation("INSPECTION_BY"),
		dataIndex: 'inspectionBy',
		flex:1,
		sortable:true,
		renderer: function(value, metadata, record) {
			if(!isNullOrEmpty(record.data.inspectionBy)){
				return record.data.inspectionByCode +'/'+record.data.inspectionBy;
			}else {
				return '';
			}
		}
	},{
		header:  getCommonTranslation("DOCUMENT_STATUS"),
		dataIndex: 'documentStatus',
		flex:1,
		sortable:true,
		renderer: function(value, metadata, record) {
			if(isNullOrEmpty(value)){
				var grid = Ext.ComponentQuery.query('managescholarshipstudentlistgrid');
				var grid1 = Ext.ComponentQuery.query('managescholarshipapplicantlistgrid');
				var selectedRecord;
				if(!isNullOrEmpty(grid[0].getSelectionModel().getSelection()[0])){
					selectedRecord = grid[0].getSelectionModel().getSelection()[0].data;				
				}else {
					selectedRecord = grid1[0].getSelectionModel().getSelection()[0].data;
				}
				return '<span class="required" style="color:red">*</span>';
			}else if(value=='SUBMITTED'){
				return '<span style="color:green">'+getCommonTranslation('SUBMITTED')+'</span>';
			}else if(value=='VERIFIED'){
				return '<span style="color:green">'+getCommonTranslation('VERIFIED')+'</span>';
			}else if(value=='RE_SUBMIT'){
				return '<span class="required" style="color:red">*</span>';
			}
		}
	},{
		header:  getCommonTranslation("REAMRK"),
		dataIndex: 'remark',
		flex:1,
		hidden:true,
		sortable:true,
	}]
});