/**
 *
 * This is used  to show add Scholarship Form
 */
Ext.define('Academia.view.scholarship.scholarshipmaster.AddScholarship', {
	//extend:'Academia.view.common.DynamicFieldForm',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	customFieldEntity:CONSTANTS.SCHOLARSHIP_CD,
    alias: 'widget.addscholarship',
    title: getCommonTranslation('ADD_SCHOLARSHIP_DETAILS'),
    autoScroll: true,
    plugins: "formlabelrequired",
    items: [{
       
            xtype: 'idgeneratorform',
            formCode: 'scholarshipForm',
            itemId: 'addscholarshipform',
            method: 'POST',
            standardSubmit: false,
            items: [{
                xtype: 'fieldcontainer',
                width: 'auto',
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                layout: {
                    type: 'hbox'
                },
                items: [{
                    xtype: 'hidden',
                    itemId: 'Id_hidden_field',
                    name: 'id'
                }, {
                    xtype: 'hidden',
                    itemId: 'versionId_hidden_field',
                    name: 'version'
                }, {
                    xtype: 'textfield',
                    fieldLabel: getCommonTranslation('SCHOLARSHIP_ID'),
                    itemId: 'scholId',
                    name: 'serialNo',
                    vtype: 'NospaceAsInput',
                    emptyText: getCommonTranslation('ID_AUTOGENERATE')
                }, {
                    xtype: 'textfield',
                    fieldLabel: getCommonTranslation('SCHOLARSHIP_NAME'),
                    allowBlank: false,
                    name: 'scholarshipName',
                    editable: false
                }, {
                    xtype: 'customcombobox',
                    fieldLabel: getCommonTranslation('SCHOLARSHIP_TYPE'),
                    name: 'scholarshipType',
                    itemId: 'ScholarshipTypeId',
                    store: 'scholarships.ScholarshipTypes',
                    allowBlank: false,
                    queryMode: 'local',
                    forceSelection: true,
                    editable: false,
                    displayField: 'value',
                    valueField: 'id',
                    editable: false
                }, {
                    xtype: 'textfield',
                    fieldLabel: getCommonTranslation('SCHOLARSHIP_NAME_OTHER_LANGUAGE'),
                    name: 'scholarshipNameOtherLanguage',
                    itemId: 'scholarshipNameOtherLanguageId'
                }]
            }, {
                xtype: 'fieldcontainer',
                width: 'auto',
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                layout: {
                    type: 'hbox'
                },
                items: [{
                    xtype: 'customcombobox',
                    fieldLabel: getCommonTranslation('ORGANIZATION_NAME'),
                    name: 'organizationId',
                    itemId: 'organizationCmb',
                    allowBlank: false,
                    forceSelection: true,
                    editable: false,
                    displayField: 'value',
                    valueField: 'id',
                    queryMode: 'local',
                    listeners: {
                    	render: function(combo) {
                    		var orgStore = Ext.create('Academia.store.scholarships.Organizations');
                    		combo.bindStore(orgStore);
                    	}
                    }
                }, {
                    xtype: 'customcombobox',
                    fieldLabel: getCommonTranslation('AMOUNT_TYPE'),
                    name: 'scholarshipAmountType',
                    itemId: 'amountTypeId',
                    store: 'scholarships.AmountTypes',
                    displayField: 'value',
                    valueField: 'id',
                    allowBlank: false,
                    queryMode: 'local',
                    forceSelection: true,
                    editable: false
                }, {
                    xtype: 'customcombobox',
                    fieldLabel: getCommonTranslation('SCHOLARSHIP_PAYMENT_TYPE'),
                    name: 'paymentType',
                    itemId: 'paymentId',
                    store: 'scholarships.ScholarshipPaymentTypes',
                    displayField: 'value',
                    valueField: 'id',
                    allowBlank: false,
                    queryMode: 'local',
                    forceSelection: true,
                    editable: false
                }, {
                    xtype: 'statusCombo',
                    name: 'scholarshipStatus',
                    allowBlank: false,
                    itemId: 'cmbStatus',
                    editable: false
                }]
            }, {
                xtype: 'fieldcontainer',
                width: 'auto',
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                layout: {
                    type: 'hbox'
                },
                items: [{
                	xtype: 'datefield',
        			name: 'scholarshipValidFrom',
        			itemId: 'scholarshipValidFromId',
        			vtype: 'daterange',
        			editable: false,
        			fieldLabel: getCommonTranslation('SCHOLARSHIP_VALID_FROM'),
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				},
        				change:function(obj,val){
        					var form = obj.up('form');
        					var validToDate = form.down('#scholarshipValidTillId');
							if (!isNullOrEmpty(val)) {
								var minValue = Ext.Date.add(new Date(val), Ext.Date.DAY, 1);
								validToDate.setMinValue(minValue);	
							} else {
								validToDate.setMinValue(null);	
							}
						}
        			}
        		}, {
        			xtype: 'datefield',
        			name: 'scholarshipValidTill',
        			itemId: 'scholarshipValidTillId',
        			vtype: 'daterange',
        			editable: false,
        			fieldLabel: getCommonTranslation('SCHOLARSHIP_VALID_TILL'),
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				},
        				change:function(obj,val){
        					var form = obj.up('form');
        					var validFromDate = form.down('#scholarshipValidFromId');
							if (!isNullOrEmpty(val)) {
								var maxValue = Ext.Date.add(new Date(val), Ext.Date.DAY, -1);
								validFromDate.setMaxValue(maxValue);	
							} else {
								validFromDate.setMaxValue(null);
							}
						}
        			}
        		}, {
                    xtype: 'textfield',
                    fieldLabel: getCommonTranslation('VALIDITY_IN_MONTH'),
                    itemId: 'validityId',
                    name: 'validityInMonth',
                    allowBlank: false,
                    minValue: 0,
                    maxLength: 2,
                    maskRe: /[0-9]/
        	    }, {
                    xtype: 'customcombobox',
                    fieldLabel: getCommonTranslation('COST_CENTRE'),
                    name: 'costCentreId',
                    itemId: 'costCentreId',
                    store: 'scholarships.ScholarshipCostCentreStore',
                    displayField: 'value', 
                    valueField: 'id',
                    queryParam:'qry',
	   				minChars:3,
	   				typeAhead:false,
	   				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	   				forceSelection:true,
	   				listConfig: {
	   					listeners: {
	   						beforeshow: function(picker) {
	   							picker.minWidth = picker.up('combobox').getSize().width;
	   						}
	   					},
	   					loadingText: getCommonTranslation('SEARCHING'),
	   					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	   					getInnerTpl: function() {
	   						return '<div class="search-item">' +
	   						'{value}'+
	   						'</div>';
	   					}
	   				}
        		}]
            }, {
                xtype: 'fieldcontainer',
                width: 'auto',
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                layout: {
                    type: 'hbox'
                },
                items: [{
                    xtype: 'textfield',
                    fieldLabel: getFeeAndPaymentCommonTranslation('TOTAL_AMOUNT'),
                    name: 'amount',
                    allowBlank: false,
                    minValue: 0,
                    maxLength: 20,
                    itemId: 'amountId',
                    maskRe: /[0-9.]/,
                    validator: function(v) {
                        return /^\d{0,20}$/.test(v) ? true : "Invalid Number";
                    }
               }, {
	                xtype: 'customcombobox',
	                fieldLabel: getCommonTranslation('DISBURSEMENT_MODE'),
	                name: 'disbursementMode',
	                itemId: 'disbursementMode',
	                store: 'scholarships.DisbursmentModes',
	                displayField: 'value',
	                valueField: 'id',
	                allowBlank: false,
	                queryMode: 'local',
	                forceSelection: true,
	                editable: false,
	                onFocus: function() {
                        var me = this;
                        if(!viewMode){
                        	 if (!me.isExpanded) {
                                 me.expand()
                             }
                             me.getPicker().focus();
                        }
                    },
	           }, {
	                xtype: 'customcombobox',
	                fieldLabel: getCommonTranslation('CURRENCY'),
	                name: 'currencyId',
	                itemId : 'currencyId',
	                store: 'feeandpayment.ActiveCurrencyStore',
	                valueField: 'id',
					displayField: 'name',
	                allowBlank: false,
	                forceSelection: true,
	                queryMode: 'local',
	                editable: false
	           }, {
	                xtype: 'customcombobox',
	                fieldLabel: getCommonTranslation('GRADUATE_LEVEL'),
	                name: 'graduateLevel',
	                itemId: 'graduateLevelId',
	                store: 'scholarships.GraduateLevelStore',
	                displayField: 'value',
	                valueField: 'id',
	                queryMode: 'local',
	                editable: false,
	                forceSelection: true
                }]
            }, {
    			xtype:'panel',
    			itemId: 'feeHeadsPanel',
    			style:{margin:'0px'},
    			width: '100%',
    			items:[{
    				xtype: 'fieldcontainer',
    				width: '100%',
    				layout: {
    					type: 'hbox',
    					align: 'bottom'
    				},defaults:{
    					width: 256,
    					labelAlign: 'top',
        				
    				},
    				items: [{
    					xtype: 'customcombobox',
    					itemId: 'feeHeads',
    					name: 'feeHeads',    					
    					fieldLabel: getFeeAndPaymentCommonTranslation('FEES_HEADS'),
    					store: Ext.create('Academia.store.feeandpayment.reports.FeeHeadWiseFeeReportStore'),
        			    valueField: 'id',
    					displayField: 'value',
    					//typeAhead:true,
    				    forceSelection:true,
    				    editable: false,
    					allowBlank: false
    				},{
    					xtype: 'customcombobox',
    					itemId: 'amountOrPercentage',
    					name: 'amountOrPercentage',
    					fieldLabel: getFeeAndPaymentCommonTranslation('AMOUNT_OR'),
    					labelAlign: 'top',
    					valueField: 'id',
    					displayField: 'value',
    					store:Ext.create('Academia.store.feeandpayment.FeeAmount'),
    					typeAhead:true,
     	        	    forceSelection:true,
     	        	    editable: false,
    					allowBlank: false,
    					listeners:{
    						select:function(cmp,record){
    							cmp.up().down('#feeAmounts').reset();
    							if(record[0].data.id == "PERCENTAGE"){
    								cmp.up().down('#feeAmounts').setMaxValue(100);
    								cmp.up().down('#feeAmounts').setMinValue(1);
    							}else{
    								cmp.up().down('#feeAmounts').setMaxValue(10000000000000000000);
    								cmp.up().down('#feeAmounts').setMinValue(1)
    						}
    					  }
    					}
    				},{
    					xtype:'numberfield',
    					enableKeyEvents : true,
    					itemId: 'feeAmounts',
    					name: 'feeAmounts',
    					fieldLabel: getFeeAndPaymentCommonTranslation('FEES_AMOUNT'),
    					allowBlank:false,
    					hideTrigger:true,
    					listeners:{
    						change : function(comp, newVal, oldVal){
    							var form = comp.up('#addscholarshipform');
    							 var amountField = form.down('#amountId');
    							var totalAmt = form.down('#amountId').getValue();
    							
    							
    							 var addForm =  comp.up('#addscholarshipform');
 	    						
  						 	   var feeHeadsPanel = addForm.down('#feeHeadsPanel');   	 
  						 	   var amountFld = addForm.down('#amountId');
  						 	   var totalAMountOfFeeHead=0;
  						 	   var feeHeadPanelLength  = feeHeadsPanel.items.items.length;
  							   var feeHeadItems = feeHeadsPanel.items.items;						
  							   var remainingAmt = 0;
  							   var feeAmtVal ;
  							   var remainingAmtOfFeeHead ;
  					 		   var percentDataArray = new Array();
  					 			
  					 	   
    							if(totalAmt){
    								
    								 for(var i = 0;i< feeHeadPanelLength ;i++){
      					 				 if(feeHeadItems[i].items.items[1].getValue() == "PERCENTAGE"){
      					 					 if(feeHeadItems[i].items.items[1].getValue() == 100){
      					 						percentDataArray.push(feeHeadItems[i].items.items[1].getValue());
      					 					 }
      					 					var totalAmt = parseInt(amountFld.getValue());
      					 					remainingAmt =totalAmt-totalAMountOfFeeHead;
      					 					feeAmtVal =feeHeadItems[i].items.items[2].getValue();
      					 					remainingAmtOfFeeHead= remainingAmt* feeAmtVal/100;
      					 					totalAMountOfFeeHead = remainingAmtOfFeeHead+totalAMountOfFeeHead;
      					 				 }
      					 				 else{
      					 					totalAMountOfFeeHead = totalAMountOfFeeHead+feeHeadItems[i].items.items[2].getValue(); 
      					 				 }
      					 			 }
    								 if(totalAMountOfFeeHead > parseInt(amountFld.getValue())){
      					 				 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SUM_OF_FEE_HEADS_AMOUNT_EXCEEDING_THE_TOTAL_AMOUNT'));
      					 				comp.reset();
      					 			 }
    								 else if(totalAMountOfFeeHead == parseInt(amountFld.getValue())){
    									  if(percentDataArray.length >1){
    											 showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('SUM_OF_FEE_HEADS_AMOUNT_EXCEEDING_THE_TOTAL_AMOUNT'));
    		      					 				comp.reset();
    		      					 			
    									  }
    								 }
    							}else{
    								if(!amountField.config.showAlert){
    									showWarningMessage(getCommonTranslation('ALERT'),getCommonTranslation('PLEASE_FILL_TOTAL_AMOUNT'));
    	    							
    								  }
    									comp.reset();
    							}
    							
    						}
    				  }
    					
    					
    				},{
    					xtype: 'button',
    					itemId: 'addFeeHeadBtn',
    					cls: 'CustomBodyBtnSettings',
    					text: getCommonTranslation('ADDBUTTONTEXT'),
    					tooltip: getCommonTranslation('ADD')
    				}] 
    			}]
            }, {
                xtype: 'fieldcontainer',
                width: 'auto',
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                layout: {
                    type: 'hbox'
                },
                items: [{
                	xtype: 'textfield',
                    fieldLabel: getCommonTranslation('MAX_AMOUNT_PER_STUDENT'),
                    name: 'maxAmountPerStudent',
                    itemId: 'maxAmountPerStudentId',
                    allowBlank: false,
                    minValue: 0,
                    maxLength: 10,
                    maskRe: /[0-9]/
                },{
                	xtype: 'textfield',
                    fieldLabel: getCommonTranslation('SCHOLARSHIP_BUDGET_AMOUNT'),
                    name: 'budgetAmount',
                    itemId: 'budgetAmountId',
                    allowBlank: false,
                    minValue: 0,
                    maxLength: 10,
                    maskRe: /[0-9]/
                },{
	                xtype: 'customcombobox',
	                fieldLabel: getCommonTranslation('SCHOLARSHIP_PURPOSE'),
	                name: 'purpose',
	                itemId: 'purposeId',
	                store: 'scholarships.ScholarshipPurposeStore',
	                displayField: 'value',
	                valueField: 'id',
	                queryMode: 'local',
	                editable: false,
	                forceSelection: true
                },{
	                xtype: 'customcombobox',
	                fieldLabel: getCommonTranslation('FUND_TYPE'),
	                name: 'fundType',
	                itemId: 'fundTypeId',
	                store: 'scholarships.FundTypeStore',
	                displayField: 'value',
	                valueField: 'id',
	                queryMode: 'local',
	                editable: false,
	                forceSelection: true
                }]
    		},{
                xtype: 'fieldcontainer',
                width: 'auto',
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                layout: {
                    type: 'hbox'
                },
                items: [{
                    xtype: 'textfield',
                    fieldLabel: getCommonTranslation('MAX_NO_OF_AWARDEE'),
                    name: 'maxNoAwardees',
                    allowBlank: false,
                    minValue: 0,
                    maskRe: /[0-9]/
                }, {
                    xtype: 'customcombobox',
                    fieldLabel: getCommonTranslation('APPLICATION_MODE'),
                    name: 'applicationMode',
                    itemId: 'appModeId',
                    store: 'scholarships.ApplicationModes',
                    displayField: 'value',
                    queryMode: 'local',
                    valueField: 'id',
                    allowBlank: false,
                    editable: false,
                    forceSelection: true,
                    onFocus: function() {
                        var me = this;
                        if(!viewMode){
                        	if (!me.isExpanded) {
                                me.expand()
                            }
                            me.getPicker().focus();
                        }
                     }
                }, {
                    xtype: 'customcombobox',
                    fieldLabel: getCommonTranslation('SELECTION_TYPE'),
                    name: 'selectionType',
                    itemId: 'selTypeId',
                    store: 'scholarships.SelectionTypes',
                    displayField: 'value',
                    valueField: 'id',
                    allowBlank: false,
                    queryMode: 'local',
                    forceSelection: true,
                    editable: false,
                    onFocus: function() {
                        var me = this;
                        if(!viewMode){
                        	 if (!me.isExpanded) {
                                 me.expand()
                             }
                             me.getPicker().focus();
                        }
                    },
                }, {
                	xtype: 'multiselectcombofield',
					name: 'ownerIds',
					itemId:'ownerItemIds',
					fieldLabel: getCommonTranslation('SCHOLARSHIP_OWNER'),
					store:'scholarships.ScholarshipOwnersStore',
					valueField: 'id',
					forceSelection:true,
					displayField: 'value',
					cls:'commonAutoHeightMultiselectField',
					queryParam:'qry',
					minChars:3,
					typeAhead:true,
					enableKeyEvents  : 'true',
					hideTrigger:false,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND')
					}
                }]
            }, {
                xtype: 'fieldcontainer',
                width: 'auto',
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                layout: {
                    type: 'hbox'
                },
                items: [{
                	xtype      : 'radiogroup',
	   				fieldLabel : getCommonTranslation('COVERS_OLD_DEBT'),
	   				itemId: 'coversOldDebtId',
	   				name: 'coversOldDebt',
	   				defaults: {
	   					flex: 1
	   				},
	   				layout: 'hbox',
	   				items:[{ 
	   					boxLabel: getCommonTranslation('YES'), 
	   					name: 'coversOldDebt', 
	   					inputValue: true,
	   					checked:true
	   				},{ 
	   					boxLabel: getCommonTranslation('NO'), 
	   					name: 'coversOldDebt', 
	   					inputValue: false
	   				}]
                },{
                	xtype      : 'radiogroup',
	   				fieldLabel : getCommonTranslation('ALLOCATE_BALANCE_ON'),
	   				itemId: 'allocateBalanceOnId',
	   				name: 'allocateBalanceOn',
	   				defaults: {
	   					flex: 1
	   				},
	   				layout: 'hbox',
	   				items:[{ 
	   					boxLabel: getCommonTranslation('YES'), 
	   					name: 'allocateBalanceOn', 
	   					inputValue: true
	   				},{ 
	   					boxLabel: getCommonTranslation('NO'), 
	   					name: 'allocateBalanceOn', 
	   					inputValue: false,
	   					checked:true
	   				}]
                },{
                	xtype      : 'radiogroup',
	   				fieldLabel : getCommonTranslation('DAR_SCHOLARSHIP'),
	   				itemId: 'darScholarshipId',
	   				name: 'darScholarship',
	   				defaults: {
	   					flex: 1
	   				},
	   				layout: 'hbox',
	   				items:[{ 
	   					boxLabel: getCommonTranslation('YES'), 
	   					name: 'darScholarship', 
	   					inputValue: true
	   				},{ 
	   					boxLabel: getCommonTranslation('NO'), 
	   					name: 'darScholarship', 
	   					inputValue: false,
	   					checked:true
	   				}]
                },{
	   				xtype: 'customcombobox',
	   				name:'financingInstitutionId',
	   				itemId:'financingInstitutionId',
	   				store: 'scholarships.ScholarshipSponsorsStore',
	   				fieldLabel: getCommonTranslation('FINANCING_INSTITUTION'),
	   				valueField: 'id',
	   				displayField: 'value',
	   				queryParam:'qry',
	   				minChars:3,
	   				typeAhead:false,
	   				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	   				forceSelection:true,
	   				listConfig: {
	   					listeners: {
	   						beforeshow: function(picker) {
	   							picker.minWidth = picker.up('combobox').getSize().width;
	   						}
	   					},
	   					loadingText: getCommonTranslation('SEARCHING'),
	   					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	   					getInnerTpl: function() {
	   						return '<div class="search-item">' +
	   						'{value}'+
	   						'</div>';
	   					}
	   				}
                }]
    		}, {
                xtype: 'fieldcontainer',
                width: 'auto',
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                layout: {
                    type: 'hbox'
                },
                items: [{
                	xtype      : 'radiogroup',
	   				fieldLabel : getCommonTranslation('SCHOLARSHIP_APPLICATION_REQUIRED'),
	   				itemId: 'applicationRequiredId',
	   				name: 'applicationRequired',
	   				defaults: {
	   					flex: 1
	   				},
	   				layout: 'hbox',
	   				items:[{ 
	   					boxLabel: getCommonTranslation('YES'), 
	   					name: 'applicationRequired', 
	   					inputValue: true,
	   					checked:true
	   				},{ 
	   					boxLabel: getCommonTranslation('NO'), 
	   					name: 'applicationRequired', 
	   					inputValue: false
	   				}]
                },{
                	xtype: 'datefield',
        			name: 'applicationStartDate',
        			itemId: 'applicationStartDateId',
        			vtype: 'daterange',
        			editable: false,
        			fieldLabel: getCommonTranslation('SCHOLARSHIP_APPLICATION_START_DATE'),
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				},
        				change:function(obj,val){
        					var form = obj.up('form');
        					var endDate = form.down('#applicationEndDateId');
							if (!isNullOrEmpty(val)) {
								var minValue = Ext.Date.add(new Date(val), Ext.Date.DAY, 1);
								endDate.setMinValue(minValue);
							} else {
								endDate.setMinValue(null);	
							}
						}
        			}
        		}, {
        			xtype: 'datefield',
        			name: 'applicationEndDate',
        			itemId: 'applicationEndDateId',
        			vtype: 'daterange',
        			editable: false,
        			fieldLabel: getCommonTranslation('SCHOLARSHIP_APPLICATION_END_DATE'),
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				},
        				change:function(obj,val){
        					var form = obj.up('form');
        					var fromDate = form.down('#applicationStartDateId');
							if (!isNullOrEmpty(val)) {
								var maxValue = Ext.Date.add(new Date(val), Ext.Date.DAY, -1);
								fromDate.setMaxValue(maxValue);	
							} else {
								fromDate.setMaxValue(null);
							}
						}
        			}
                },{
                	xtype      : 'radiogroup',
	   				fieldLabel : getCommonTranslation('ALLOW_APPLICATION_AFTER_END_DATE'),
	   				itemId: 'allowApplicationAfterEndDateId',
	   				name: 'allowApplicationAfterEndDate',
	   				defaults: {
	   					flex: 1
	   				},
	   				layout: 'hbox',
	   				items:[{ 
	   					boxLabel: getCommonTranslation('YES'), 
	   					name: 'allowApplicationAfterEndDate', 
	   					inputValue: true
	   				},{ 
	   					boxLabel: getCommonTranslation('NO'), 
	   					name: 'allowApplicationAfterEndDate', 
	   					inputValue: false,
	   					checked:true
	   				}]
                }]
            }, {
                xtype: 'fieldcontainer',
                width: 'auto',
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                layout: {
                    type: 'hbox'
                },
                items: [{
                    xtype: 'checkbox',
                    boxLabel: getCommonTranslation('ADJUSTMENT'),
                    allowBlank: false,
                    itemId: 'AdjustmentAllowed',
                    name: 'adjustmentAllowed',
                    inputValue: 'true',
                    uncheckedValue: 'false'
                }, {
                    xtype: 'checkbox',
                    boxLabel: getCommonTranslation('ALLOW'),
                    allowBlank: false,
                    inputValue: 'true',
                    uncheckedValue: 'false',
                    name: 'allowConcessionCandidate'
                }]
            }, {
                xtype: 'label',
                style: {
                    'font-weight': 'bold',
                    'text-decoration': 'underline'
                },
                text: getCommonTranslation('ADD_ELIGIBILITY_CRITERIA'),
                allowBlank: false,
                name: 'label'
            }, {
                xtype: 'fieldcontainer',
                width: 'auto',
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                layout: {
                    type: 'hbox'
                },
                items: [{
                    xtype: 'textfield',
                    allowBlank: false,
                    fieldLabel: getCommonTranslation('AGENDA_FOR_DROOLS'),
                    name: 'droolAgenda',
                    maxLength: 150,
                }, {
                    xtype: 'textareafield',
                    fieldLabel: getCommonTranslation('DESCRIPTION'),
                    name: 'droolAgendaDescription',
                    allowBlank: false,
                    itemId: 'descId',
                    enableKeyEvents: true,
                    maxLength: 255,
                }, {
                    xtype: 'textareafield',
                    fieldLabel: getCommonTranslation('DESCRIPTION_OTHER_LANGUAGE'),
                    name: 'droolAgendaDescriptionOtherLanguage',
                    itemId: 'descOtherLanId',
                    maxLength: 255,
                    enableKeyEvents: true
                }]
            }]
        }, {
            xtype: 'panel',
            collapsible: true,
            title: 'Periods',
            hidden: true,
            itemId: 'PeriodsFormId',
            name: 'panelname',
            items: [{
                xtype: 'periodsgrid',
                itemId: 'addScholarshipPeriodGrid',
                name: 'scholarshipInstallments'
            }]
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            style: {
                marginLeft: '12px'
            },
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'addScholarshipBtn',
                formBind: true,
                action: 'save',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE
            }, {
                xtype: 'button',
                text: getExaminationTranslation('RESET'),
                itemId: 'resetButtonId',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                handler: function() {
                    this.up('form').getForm().reset();
                }
            }]
        }
    ]
});