/**
 * @author Niklesh T
 * 
 */
var scholarshipCategoryStore = Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data: [{
		id:'DEPARTMENTAL',
		value:getCommonTranslation('DEPARTMENTAL') 
	},{
		id:'NOMINATION',
		value:getCommonTranslation('NOMINATION') 
	},{ 
		value:getCommonTranslation('NSFAS'), 
		id:'NSFAS'
	},{ 
		value:getCommonTranslation('NRF'), 
		id:'NRF'
	}]
});

var scholarshipTypesStore = Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data: [{
		id:'INT',
		value:getCommonTranslation('INTERNAL') 
	},{
		id:'EXT',
		value:getCommonTranslation('EXTERNAL')  
	}]
});

var graduateLeveStore = Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data: [{
		id:'UNDERGRADUATE',
		value:getCommonTranslation('UNDERGRADUATE')
	},{
		id:'POST_GRADUATE',
		value:getCommonTranslation('POSTGRADUATE') 
	}]
});
var awardWithOtherStore = Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data: [{
		id:'YES',
		value:getCommonTranslation('YES') 
	},{
		id:'NO',
		value:getCommonTranslation('NO') 
	},{
		id:'ONLY_ALLOWED_SCHOLARSHIP',
		value:getCommonTranslation('ONLY_ALLOWED_SCHOLARSHIP') 
	}]
});
var awardCancellationStore = Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data: [{
		id:'CAN_NOT_CANCEL',
		value:getCommonTranslation('CAN_NOT_CANCEL') 
	},{
		id:'PARTIAL_CANCELLATION',
		value:getCommonTranslation('PARTIAL_CANCELLATION') 
	},{
		id:'FULL_CANCELLATION',
		value:getCommonTranslation('FULL_CANCELLATION') 
	}]
});
var AmountTypeStore = Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data: [{
		id:'FIX',
		value:getCommonTranslation('FIXED')
	},{
		id:'ADH',
		value:getCommonTranslation('AD_HOC') 
	}]
});
var ApplicationMode = Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data: [{
		id:'INS',
		value:getCommonTranslation('THROUGHT_INSTITUTE')
	},{
		id:'DIR',
		value:getCommonTranslation('DIRECT') 
	}]
});
Ext.define('Academia.view.scholarship.scholarshipmaster.AddScholarshipTabForm', {
	//extend:'Academia.view.common.DynamicFieldForm',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	customFieldEntity:CONSTANTS.SCHOLARSHIP_CD,
    alias: 'widget.addscholarshiptabform',
    title: getCommonTranslation('SCHOLARSHIP_DETAILS'),
	cls: 'basicScholarshipInfoDetailsItemCls',
	layout: 'vbox',
    bodyStyle:{
    	padding: '8px 10px'
    },
    plugins: "formlabelrequired",
    layout: 'vbox',
    cls:'x-form-fixed-footer-parent',
    items:[{
    	xtype:'fieldset',
		title: getCommonTranslation('BASIC_SCHOLARSHIP_INFORMATION'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:false,
		itemId : 'basicScholarshipInfoDetailsItemId',
	    items: [{ 
	            xtype: 'form',
	            formCode: 'scholarshipForm',
	            itemId: 'addscholarshipform',
	            method: 'POST',
	            standardSubmit: false,
	            items: [{
	                xtype: 'fieldcontainer',
	                width: 'auto',
	                defaults: {
	                    labelAlign: 'top',
	                    width: 240
	                },
	                layout: {
	                    type: 'hbox'
	                },
	                items: [{
	                    xtype: 'hidden',
	                    itemId: 'Id_hidden_field',
	                    name: 'id'
	                }, {
	                    xtype: 'hidden',
	                    itemId: 'versionId_hidden_field',
	                    name: 'version'
	                }, {
	                    xtype: 'textfield',
	                    fieldLabel: getCommonTranslation('SCHOLARSHIP_ID'),
	                    itemId: 'scholId',
	                    name: 'serialNo',
	                    vtype: 'NospaceAsInput',
	                    emptyText: getCommonTranslation('ID_AUTOGENERATE'),
	                	maxLength: 99,
	                	forceSelection:true,
	                }, {
	                    xtype: 'textfield',
	                    fieldLabel: getCommonTranslation('SCHOLARSHIP_NAME'),
	                    itemId: 'scholarshipNameId',
	                    allowBlank: false,
	                    name: 'scholarshipName',
	                    editable: false
	                }, {
	                    xtype: 'textfield',
	                    fieldLabel: getCommonTranslation('SCHOLARSHIP_NAME_OTHER_LANGUAGE'),
	                    name: 'scholarshipNameOtherLanguage',
	                    itemId: 'scholarshipNameOtherLanguageId'
	                },
	                {
	                    xtype: 'customcombobox',
	                     fieldLabel: getCommonTranslation('SCHOLARSHIP_CATEGORY'),
	                     name: 'scholarshipCategory',
	                     itemId: 'scholarshipCategory',
	                     editable: false,
	                     store: scholarshipCategoryStore,
	                     displayField: 'value',
	                     valueField: 'id',
	                     typeAhead:true,
	                     forceSelection:true,
	                     allowBlank:false,
	                 }]
	            }, {
	                xtype: 'fieldcontainer',
	                width: 'auto',
	                defaults: {
	                    labelAlign: 'top',
	                    width: 240
	                },
	                layout: {
	                    type: 'hbox'
	                },
	                items: [{
	                    xtype: 'customcombobox',
	                    fieldLabel: getCommonTranslation('ORGANIZATION_NAME'),
	                    name: 'organizationId',
	                    itemId: 'organizationCmb',	                    
	                    forceSelection: true,
	                    editable: false,
	                    displayField: 'value',
	                    valueField: 'id',
	                    queryMode: 'local',
	                    store: Ext.create('Academia.store.scholarships.ScholarshipOrganizationStore'),
	                },{
	                    xtype: 'customcombobox',
	                    fieldLabel: getCommonTranslation('SCHOLARSHIP_TYPE'),
	                    name: 'scholarshipType',
	                    itemId: 'ScholarshipTypeId',
	                    store: scholarshipTypesStore,
	                    typeAhead:true,
	                    forceSelection:true,
	                    editable: false,
	                    displayField: 'value',
	                    valueField: 'id'
	                    
	                }, {
		                xtype: 'customcombobox',
		                fieldLabel: getCommonTranslation('GRADUATE_LEVEL'),
		                name: 'graduateLevel',
		                itemId: 'graduateLevelId',
		                store: graduateLeveStore,
		                displayField: 'value',
		                valueField: 'id',
		                queryMode: 'local',
		                editable: false,
		                forceSelection: true
	                }, {
		                xtype: 'customcombobox',
		                fieldLabel: getCommonTranslation('CURRENCY'),
		                name: 'currencyId',
		                itemId : 'currencyId',
		                store: Ext.create('Academia.store.scholarships.ScholarshipCurrencyStore'),
		                valueField: 'id',
						displayField: 'name',
		                allowBlank: false,
		                forceSelection: true,
		                queryMode: 'local',
		                editable: false
		           }
	                ]
	            }, {
	                xtype: 'fieldcontainer',
	                width: 'auto',
	                defaults: {
	                    labelAlign: 'top',
	                    width: 240
	                },
	                layout: {
	                    type: 'hbox'
	                },
	                items: [{
	                	xtype: 'datefield',
	        			name: 'scholarshipValidFrom',
	        			itemId: 'scholarshipValidFromId',
	        			vtype: 'daterange',
	        			editable: false,
	        			fieldLabel: getCommonTranslation('SCHOLARSHIP_VALID_FROM'),
	        			listeners: {
	        				render: function(field) {
	        					return dateFormatRender(field);
	        				},
	        				change:function(obj,val){
	        					var form = obj.up('form');
	        					var validToDate = form.down('#scholarshipValidTillId');
								if (!isNullOrEmpty(val)) {
									var minValue = Ext.Date.add(new Date(val), Ext.Date.DAY, 1);
									validToDate.setMinValue(minValue);	
								} else {
									validToDate.setMinValue(null);	
								}
							}
	        			}
	        		}, {
	        			xtype: 'datefield',
	        			name: 'scholarshipValidTill',
	        			itemId: 'scholarshipValidTillId',
	        			vtype: 'daterange',
	        			editable: false,
	        			fieldLabel: getCommonTranslation('SCHOLARSHIP_VALID_TILL'),
	        			listeners: {
	        				render: function(field) {
	        					return dateFormatRender(field);
	        				},
	        				change:function(obj,val){
	        					var form = obj.up('form');
	        					var validFromDate = form.down('#scholarshipValidFromId');
								if (!isNullOrEmpty(val)) {
									var maxValue = Ext.Date.add(new Date(val), Ext.Date.DAY, -1);
									validFromDate.setMaxValue(maxValue);	
								} else {
									validFromDate.setMaxValue(null);
								}
							}
	        			}
	        		}, {
	                    xtype: 'textfield',
	                    fieldLabel: getCommonTranslation('VALIDITY_IN_MONTH'),
	                    name: 'validityInMonth',
	                    itemId: 'validityId',
	                    minValue: 0,
	                    maxLength: 2,
	                    maskRe: /[0-9]/
	        	    }, {
	                    xtype: 'statusCombo',
	                    name: 'scholarshipStatus',
	                    allowBlank: false,
	                    itemId: 'cmbStatus',
	                    editable: false,
	                    value: getCommonTranslation('ACTIVE'),
	                }]
	            }, {
	                xtype: 'fieldcontainer',
	                width: 'auto',
	                defaults: {
	                    labelAlign: 'top',
	                    width: 240
	                },
	                layout: {
	                    type: 'hbox'
	                },
	                items: [{
		                xtype: 'multiselectcombofield',
		                fieldLabel: getCommonTranslation('SCHOLARSHIP_PURPOSE'),
		                name: 'purpose',
		                itemId: 'purposeId',
		                store: Ext.create('Academia.store.scholarships.PurposeStore'),
		                displayField: 'value',
		                valueField: 'id',
		                queryMode: 'local',
		                editable: false,
		                forceSelection: true 
	                },{
		                xtype: 'customcombobox',
		                fieldLabel: getCommonTranslation('FUND_TYPE'),
		                name: 'fundType',
		                itemId: 'fundTypeId',
		                store: Ext.create('Academia.store.scholarships.FunTypeStore'),		                
		                displayField: 'value',
		                valueField: 'id',
		                queryMode: 'local',
		                editable: false,
		                forceSelection: true
	                },{
		   				xtype: 'customcombobox',
		   				name:'financingInstitutionId',
		   				itemId:'financingInstitutionId',
		   				store: Ext.create('Academia.store.scholarships.FinancingInstitutionStore'),
		   				fieldLabel: getCommonTranslation('FINANCING_INSTITUTION'),
		   				valueField: 'id',
		   				displayField: 'value',
		   				queryParam:'qry',
		   				minChars:3,
		   				typeAhead:false,
		   				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		   				forceSelection:true,
		   				listConfig: {
		   					listeners: {
		   						beforeshow: function(picker) {
		   							picker.width = picker.up('combobox').getSize().width;
		   						}
		   					},
		   					loadingText: getCommonTranslation('SEARCHING'),
		   					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		   					getInnerTpl: function() {
		   						return '<div class="search-item">' +
		   						'{value}'+
		   						'</div>';
		   					}
		   				}
	                },{
	                	xtype: 'multiselectcombofield',
	    				name: 'ownerIds',
	    				itemId: 'ownerItemIds',
	    				width: 240,
	    				fieldLabel:getCommonTranslation('SCHOLARSHIP_OWNER'),
	    				store:Ext.create('Academia.store.scholarships.ScholarshipOwner'),
	    				queryParam: "qry",
	    				displayField: 'value',
		                valueField: 'id',
	    				forceSelection : true,
	    				//cls:'commonAutoHeightMultiselectField',
	    				hideTrigger:false,
	    				typeAhead:true,
	    				triggerAction: 'all',
	    				minChars:3,		
	    				allowBlank: false,
	    				emptyText: getCommonTranslation('ENTER_THREE_CHAR')	,
	    				autoFitErrors: false
	                	/*xtype: 'multiselectcombofield',
						name: 'ownerIds',
						itemId:'ownerItemIds',
						fieldLabel: getCommonTranslation('SCHOLARSHIP_OWNER'),
						store: Ext.create('Academia.store.scholarships.ScholarshipOwner'),
						valueField: 'id',
						forceSelection:true,
						displayField: 'value',
						allowBlank: false,
						cls:'commonAutoHeightMultiselectField resetPasswordMultiselect',
						editable: false,
	                	name: 'ownerIds',
	    				itemId: 'ownerItemIds',
	    				width: 240,
	    				fieldLabel:getCommonTranslation('SCHOLARSHIP_OWNER'),
	    				store:Ext.create('Academia.store.scholarships.ScholarshipOwner'),
	    				queryParam: "qry",
	    				displayField: 'value',
		                valueField: 'id',
	    				forceSelection : true,
	    				//cls:'commonAutoHeightMultiselectField',
	    				hideTrigger:false,
	    				typeAhead:true,
	    				triggerAction: 'all',
	    				minChars:3,		
	    				allowBlank: false,
	    				emptyText: getCommonTranslation('ENTER_THREE_CHAR')	,
	    				autoFitErrors: false,
						listConfig: {
							listeners: {
								beforeshow: function(picker) {
									picker.width = picker.up('combobox').getSize().width;
								}
							},
							loadingText: getCommonTranslation('SEARCHING'),
							emptyText: getCommonTranslation('NO_RECORDS_FOUND')
						}*/
	                }]
	            },{
	                xtype: 'fieldcontainer',
	                width: 'auto',
	                defaults: {
	                    labelAlign: 'top',
	                    width: 240
	                },
	                layout: {
	                    type: 'hbox'
	                },
	            items:[{
                	xtype      : 'radiogroup',
	   				fieldLabel : getCommonTranslation('COVERS_OLD_DEBT'),
	   				itemId: 'coversOldDebtId',
	   				name: 'coversOldDebt',
	   				defaults: {
	   					flex: 1
	   				},
	   				layout: 'hbox',
	   				items:[{ 
	   					boxLabel: getCommonTranslation('YES'), 
	   					name: 'coversOldDebt', 
	   					inputValue: true
	   				},{ 
	   					boxLabel: getCommonTranslation('NO'), 	
	   					name: 'coversOldDebt', 	   					
	   					inputValue: false,
	   					checked:true
	   				}]
                },{
                	xtype      : 'radiogroup',
	   				fieldLabel : getCommonTranslation('ALLOCATE_BALANCE_ON'),
	   				itemId: 'allocateBalanceOnId',
	   				name: 'allocateBalanceOn',
	   				defaults: {
	   					flex: 1
	   				},
	   				layout: 'hbox',
	   				items:[{ 
	   					boxLabel: getCommonTranslation('YES'), 
	   					name: 'allocateBalanceOn', 
	   					inputValue: true
	   				},{ 
	   					boxLabel: getCommonTranslation('NO'), 
	   					name: 'allocateBalanceOn', 
	   					inputValue: false,
	   					checked:true
	   				}]
                },{
                	xtype      : 'radiogroup',
	   				fieldLabel : getCommonTranslation('DAR_SCHOLARSHIP'),
	   				itemId: 'darScholarshipId',
	   				name: 'darScholarship',
	   				defaults: {
	   					flex: 1
	   				},
	   				layout: 'hbox',
	   				items:[{ 
	   					boxLabel: getCommonTranslation('YES'), 
	   					name: 'darScholarship', 
	   					inputValue: true
	   				},{ 
	   					boxLabel: getCommonTranslation('NO'), 
	   					name: 'darScholarship', 
	   					inputValue: false,
	   					checked:true
	   				}]
                },{
                	xtype      : 'radiogroup',
	   				fieldLabel : getCommonTranslation('ALLOW_INACTIVE_STUDENT'),
	   				itemId: 'allowInactiveStudent',
	   				name: 'allowInactiveStudent',
	   				defaults: {
	   					flex: 1
	   				},
	   				layout: 'hbox',
	   				items:[{ 
	   					boxLabel: getCommonTranslation('YES'), 
	   					name: 'allowInactive', 
	   					inputValue: true
	   				},{ 
	   					boxLabel: getCommonTranslation('NO'), 
	   					name: 'allowInactive', 
	   					inputValue: false,
	   					checked:true
	   				}]
                }]
	            },{
	                xtype: 'fieldcontainer',
	                width: 'auto',
	                defaults: {
	                    labelAlign: 'top',
	                    width: 240
	                },
	                layout: {
	                    type: 'hbox'
	                },
	                items: [{
	                    xtype: 'customcombobox',
	                    fieldLabel: getCommonTranslation('APPLICATION_MODE'),
	                    name: 'applicationMode',
	                    itemId: 'appModeId',
	                    store: ApplicationMode,
	                    displayField: 'value',
		                valueField: 'id',
	                    typeAhead:true,
	                    forceSelection:true,
	                    editable: false,	                
		                
		            },{
	                	xtype      : 'radiogroup',
		   				fieldLabel : getCommonTranslation('SCHOLARSHIP_APPLICATION_REQUIRED'),
		   				itemId: 'applicationRequiredId',
		   				name: 'applicationRequired',
		   				defaults: {
		   					flex: 1
		   				},
		   				layout: 'hbox',
		   				items:[{ 
		   					boxLabel: getCommonTranslation('YES'), 
		   					name: 'applicationRequired', 
		   					inputValue: true,
		   				},{ 
		   					boxLabel: getCommonTranslation('NO'), 
		   					name: 'applicationRequired', 
		   					inputValue: false,
		   					checked:true
		   				}]
	                },{
	                	xtype: 'datefield',
	        			name: 'applicationStartDate',
	        			itemId: 'applicationStartDateId',
	        			vtype: 'daterange',
	        			editable: false,
	        			fieldLabel: getCommonTranslation('SCHOLARSHIP_APPLICATION_START_DATE'),
	        			hidden:true,
	        			listeners: {
	        				render: function(field) {
	        					return dateFormatRender(field);
	        				},
	        				change:function(obj,val){
	        					var form = obj.up('form');
	        					var endDate = form.down('#applicationEndDateId');
								if (!isNullOrEmpty(val)) {
									var minValue = Ext.Date.add(new Date(val), Ext.Date.DAY, 1);
									endDate.setMinValue(minValue);
								} else {
									endDate.setMinValue(null);	
								}
							}
	        			},
	        			minValue: new Date(new Date().getFullYear(), 0, 1),
	        			maxValue: new Date(new Date().getFullYear(), 11, 31),

	        		}, {
	        			xtype: 'datefield',
	        			name: 'applicationEndDate',
	        			itemId: 'applicationEndDateId',
	        			vtype: 'daterange',
	        			editable: false,
	        			fieldLabel: getCommonTranslation('SCHOLARSHIP_APPLICATION_END_DATE'),
	        			hidden:true,
	        			listeners: {
	        				render: function(field) {
	        					return dateFormatRender(field);
	        				},
	        				change:function(obj,val){
	        					var form = obj.up('form');
	        					var fromDate = form.down('#applicationStartDateId');
								if (!isNullOrEmpty(val)) {
									var maxValue = Ext.Date.add(new Date(val), Ext.Date.DAY, -1);
									fromDate.setMaxValue(maxValue);	
								} else {
									fromDate.setMaxValue(null);
								}
							}
	        			},
	        			minValue: new Date(new Date().getFullYear(), 0, 1),
	        			maxValue: new Date(new Date().getFullYear(), 11, 31),
	                },{
	                	xtype      : 'radiogroup',
		   				fieldLabel : getCommonTranslation('ALLOW_APPLICATION_AFTER_END_DATE'),
		   				hidden:true,
		   				itemId: 'allowApplicationAfterEndDateId',
		   				name: 'allowApplicationAfterEndDate',
		   				defaults: {
		   					flex: 1
		   				},
		   				layout: 'hbox',
		   				items:[{ 
		   					boxLabel: getCommonTranslation('YES'), 
		   					name: 'allowApplicationAfterEndDate', 
		   					inputValue: true
		   				},{ 
		   					boxLabel: getCommonTranslation('NO'), 
		   					name: 'allowApplicationAfterEndDate', 
		   					inputValue: false,
		   					checked:true
		   				}]
	                }]
	            }, {
	                xtype: 'fieldcontainer',
	                width: 'auto',
	                defaults: {
	                    labelAlign: 'top',
	                    width: 240
	                },
	                layout: {
	                    type: 'hbox'
	                },
	                items: [{
	                    xtype: 'textareafield',
	                    fieldLabel: getCommonTranslation('DESCRIPTION'),
	                    name: 'droolAgendaDescription',
	                    itemId: 'descId',
	                    enableKeyEvents: true,
	                    maxLength: 1000,
	                }, {
	                    xtype: 'textareafield',
	                    fieldLabel: getCommonTranslation('DESCRIPTION_OTHER_LANGUAGE'),
	                    name: 'droolAgendaDescriptionOtherLanguage',
	                    itemId: 'descOtherLanId',
	                    maxLength: 1000,
	                    enableKeyEvents: true
	                }]
	            }]
	        }
	    ]
    },{
		xtype:'fieldset',
		title: getCommonTranslation('ADMINISTRATION_DETAILS'),
		layout:'vbox',
		frame:true,	
		collapsible:true,
		collapsed:false,
		width:'100%',
		itemId : 'administrationDetailsItemId',
		items: [{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				width: 240,
				labelAlign: 'top'
			},
			items:[{
	            	xtype      : 'radiogroup',
	   				fieldLabel : getCommonTranslation('FUND_ADMINISTRATION'),
	   				itemId: 'fundAdminId',
	   				name: 'fundAdminName',
	   				defaults: {
	   					flex: 1
	   				},
	   				layout: 'hbox',
	   				items:[{ 	
	   					boxLabel: getCommonTranslation('INTERNAL'), 
	   					name: 'fundAdminName', 
	   					inputValue: true,
	   					checked:true
	   				},{ 
	   					boxLabel: getCommonTranslation('EXTERNAL'), 
	   					name: 'fundAdminName', 
	   					inputValue: false
	   				}]
	            },{
	                xtype: 'customcombobox',
	                fieldLabel: getCommonTranslation('INTERNAL_FUND_ADMINISTRATOR'),
	                name: 'internalFundAdmin',
	                itemId: 'internalFundAdminId',
	                store: Ext.create('Academia.store.scholarships.InternalFundAdministration'),
	                displayField: 'value',
	                valueField: 'id',
	                queryMode: 'local',
	                editable: false,
	                forceSelection: true,
	                hidden:false
                },{
	                xtype: 'customcombobox',
	                fieldLabel: getCommonTranslation('AWARD_WITH_OTHER'),
	                name: 'awardwithOther',
	                itemId: 'awardwithOtherId',
	                store: awardWithOtherStore,
	                displayField: 'value',
	                valueField: 'id',
	                queryMode: 'local',
	                editable: false,
	                hidden:true,
	                forceSelection: true,
	                listeners:{
	                	show:function(cmp){
	                		cmp.setVisible(false);
	                	}
	                }
                },{
                	xtype: 'multiselectcombofield',
    				name: 'allowSchoalrshipIDName',
    				itemId: 'allowSchoalrshipIDName',
    				width: 240,
    				fieldLabel:getCommonTranslation('ALLOWED_SCHOLARSHIP_ID'),
    				store:Ext.create('Academia.store.scholarships.allowSchoalrshipIDNameStore'),
    				queryParam: "qry",
    				displayField: 'value',
	                valueField: 'id',
	                hidden:true,
    				forceSelection : true,
    				cls:'commonAutoHeightMultiselectField',
    				hideTrigger:false,
    				typeAhead:true,
    				triggerAction: 'all',
    				minChars:3,			
    				emptyText: getCommonTranslation('ENTER_THREE_CHAR')	,
	                listeners:{
	                	show:function(cmp){
	                		cmp.setVisible(false);
	                	}
	                }
                	
                	/*xtype: 'multiselectcombofield',
                	name: 'allowSchoalrshipIDName',
    				itemId: 'allowSchoalrshipIDName',
    				width: 240,
    				fieldLabel:getCommonTranslation('ALLOWED_SCHOLARSHIP_ID'),
    				store:Ext.create('Academia.store.scholarships.allowSchoalrshipIDNameStore'),
    				queryParam: "qry",
    				displayField: 'value',
	                valueField: 'id',
	                queryMode: 'local',
	                forceSelection: true,
	                width: 240,
					labelAlign: 'top',
					
					queryParam:'qry',
					minChars:3,
					typeAhead:true,
					enableKeyEvents  : 'true',
					triggerAction: 'all',
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					hidden:true,
    				
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.width = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND')
					}*/
                }],
				},{
						xtype: 'fieldcontainer',
						layout: 'hbox',					
						items:[{ 
							
				                xtype: 'customcombobox',
				                fieldLabel: getCommonTranslation('AWARD_CANCELLATION'),
				                name: 'awardCancellation',
				                itemId: 'awardCancellationId',
				                store: awardCancellationStore,
				                displayField: 'value',
				                valueField: 'id',
				                queryMode: 'local',
				                editable: false,
				                forceSelection: true,
				                width: 240,
								labelAlign: 'top'
			              
						}]
				}],
			
			    },{
			    	xtype:'fieldset',
					title: getCommonTranslation('COST_DETAILS'),
					layout:'vbox',
					frame:true,	
					collapsible:true,
					collapsed:false,
					width:'100%',
					itemId : 'programOtherDetailsItemId',
					items: [{
						xtype: 'fieldcontainer',
						layout: 'hbox',
						defaults: {
							width: 240,
							labelAlign: 'top'
						},
						items:[{
							xtype: 'customcombobox',
							fieldLabel: getCommonTranslation('AMOUNT_TYPE'),
							name: 'scholarshipAmountType',
							itemId: 'amountTypeId',
							store: AmountTypeStore,
							displayField: 'value',
							valueField: 'id',
							allowBlank: false,
							queryMode: 'local',
							forceSelection: true,
							editable: false
						},{
		                	xtype: 'numberfield',
		                    fieldLabel: getCommonTranslation('MAX_AMOUNT_PER_STUDENT'),
		                    name: 'maxAmountPerStudent',
		                    itemId: 'maxAmountPerStudentId',
		                    allowBlank: false,
		                    minValue: 0,
		                    maxLength: 13,
		                    hideTrigger:true,
		                    allowDecimals:true,
			    			decimalPrecision: 2,
		                    maskRe: /[0-9]/
		                },{
		                    xtype: 'textfield',
		                    fieldLabel: getCommonTranslation('MAX_NO_OF_AWARDEE'),
		                    name: 'maxNoAwardees',
		                    itemId: 'maxNoAwardees',
		                    allowBlank: false,
		                    minValue: 0,
		                    maxLength: 7,
		                    maskRe: /[0-9]/
		                },]
					}],
						    
			    },{
		            xtype: 'fieldcontainer',
		            width: '100%',
		            cls:'form-fixed-footer',
		            items: [{
		                xtype: 'button',
		                text: getCommonTranslation('SAVE_&_NEXT'),
		                itemId: 'addScholarshipTabFormSaveBtnId',
		                formBind: true,
		                action: 'save',
		                ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE
		            }, {
		                xtype: 'button',
		                text: getExaminationTranslation('RESET'),
		                itemId: 'resetButtonId',
		                ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE,
		                handler: function() {
		                    this.up('form').getForm().reset();
		                }
		            }]
		        }
			    ]
});