/**
 * @author Raj Gautam
 */
Ext.define('Academia.view.scholarship.scholarshipmaster.BursaryMasterGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.bursaryMasterGrid',
	store : 'scholarships.BursaryMasterStore',
	border: true,
	autoScroll: false,
	isGridConfigurable: true,
	enableColumnHide: false,
	title: getCommonTranslation('SEARCHRESULTSGRIDHEADER'),
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'scholarships.BursaryMasterStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
        var grid=this;                   
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);     
   },
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	}, {
		/*xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH*/
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[/*{
			text:getCommonTranslation('ASSIGN_GRADE_LEVEL_ENTITIES'),
			tooltip: getCommonTranslation('ASSIGN_GRADE_LEVEL_ENTITIES'),
			itemId:'assignGradeLevelEntry'	
		}*/ {
			text: getCommonTranslation('APPLY_TO'),
			tooltip: getCommonTranslation('APPLY_TO'),
			itemId:'scholarshipApplyToBtn'
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [{
		header : getCommonTranslation('SCHOLARSHIP_ID'),
		dataIndex : 'scholarshipId',
		flex : 1,
	},{
		header : getCommonTranslation('SCHOLARSHIP_NAME'),
		dataIndex : 'scholarshipName',
		flex : 1
	},{
		header : getCommonTranslation('SCHOLARSHIP_TYPE'),
		dataIndex : 'scholarshipType',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'EXT'){
					return 'External';
				}
				if(value == 'INT'){
					return 'Internal';
				}
			}
		}
	},{
		header : getCommonTranslation('SCHOLARSHIP_AMOUNT_TYPE'),
		dataIndex : 'scholarshipAmountType',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'FIX'){
					return  getCommonTranslation('Fixed Amount');
				}
				if(value == 'ADH'){
					return  getCommonTranslation('Adhoc');
				}
			}
		}
	},{
		header : getCommonTranslation('SCHOLARSHIP_NAME_OTHER_LANGUAGE'),
		dataIndex : 'scholarshipNameOtherLanguage',
		flex : 1
	},{
		header : getCommonTranslation('SCHOLARSHIP_CATEGORY'),
		dataIndex : 'scholarshipCategory',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'DEPARTMENTAL'){
					return 'Departmental';
				}
				if(value == 'NOMINATION'){
					return 'Nomination';
				}
				if(value == 'NSFAS'){
					return 'NSFAS';
				}if(value == 'NRF'){
					return 'NRF';
				}if(value == 'ALL'){
					return 'All';
				}
			}
		}
	},{
		header : getCommonTranslation('VALID_FROM'),
		dataIndex : 'validFrom',
		flex : 1,
		renderer: function(value, metadata, record) {
            return dateRender(record.data.validFrom);
        }
	},{
		header : getCommonTranslation('Valid_Till'),
		dataIndex : 'validTill',
		flex : 1,
		renderer: function(value, metadata, record) {
            return dateRender(record.data.validTill);
        }
	},{
		header : getCommonTranslation('STATUS'),
		dataIndex : 'status',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == true){
					return 'Active';
				}
				if(value == false){
					return 'Inactive';
				}
			}
		}
	},{
		header : getCommonTranslation('CURRENCY'),
		dataIndex : 'currencyName',
		flex : 1,
	},
	{
		header : getCommonTranslation('MAXIMUM_NUMBER_OF_AWARDES'),
		dataIndex : 'maxNoAwardees',
		flex : 1,
	},{
		header : getCommonTranslation('APPLICATION_REQUIRED'),
		dataIndex : 'applicationRequired',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == true){
					return 'Yes';
				}
				if(value == false){
					return 'No';
				}
			}
		}
	},{
		header : getCommonTranslation('APPLICATION_START_DATE'),
		dataIndex : 'applicationStartDate',
		flex : 1,
		renderer: function(value, metadata, record) {
            return dateRender(record.data.applicationStartDate);
        }
	},{
		header : getCommonTranslation('APPLICATION_END_DATE'),
		dataIndex : 'applicationEndDate',
		flex : 1,
		renderer: function(value, metadata, record) {
            return dateRender(record.data.applicationEndDate);
        }
	},{
		header : getCommonTranslation('GRADUATE_LEVEL'),
		dataIndex : 'graduateLevel',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'UNDERGRADUATE'){
					return 'Undergraduate';
				}
				if(value == 'POST_GRADUATE'){
					return 'Postgraduate';
				}
			}
		}
	},{
		header : getCommonTranslation('FINANCING_INSTITUTION'),
		dataIndex : 'financingInstitution',
		flex : 1,
	},{
		header : getCommonTranslation('FUND_ADMINISTRATOR'),
		dataIndex : 'fundAdministrator',
		flex : 1,
	},{
		header : getCommonTranslation('FUND_TYPE'),
		dataIndex : 'fundType',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'PERCENTAGE_REDUCTION'){
					return  'Percentage Reduction';
				}
				if(value == 'AMOUNT_REDUCTION'){
					return  'Amount Reduction';
				}
				if(value == 'FULL_COST_SCHOLARSHIP'){
					return  'Full Cost Scholarship';
				}
				if(value == 'PARTIAL_SCHOLARSHIP'){
					return  'Partial Scholarship';
				}
				if(value == 'STUDENT_LOAN'){
					return  'Student Loan';
				}
			}
		}
	},{
		header: getCommonTranslation('PURPOSE'),
		dataIndex: 'purpose',
		flex: 1,
		renderer: function(value) {
			if (!isNullOrEmpty(value)) {
				var values = value.split(',');
				if (!Ext.isEmpty(values)) {
					if (values.length == 1) {
						if (value == 'MERIT') {
							return 'Merit';
						} if (value == 'HISTORIC_DEBT') {
							return 'Historic Debt';
						} if (value == 'SPORTS') {
							return 'Sports';
						} if (value == 'RECRUITMENT') {
							return 'Recruitment';
						} if (value == 'FINANCIAL_NEED') {
							return 'Financial Need';
						} if (value == 'SUPPORT_SCHOLARSHIP') {
							return 'Support Scholarship';
						} if (value == 'RESEARCH') {
							return 'Research';
						} if (value == 'LEADERSHIP') {
							return 'Leadership';
						} if (value == 'FAMILY') {
							return 'Family';
						} if (value == 'PRIVATE') {
							return 'Private';
						} if (value == 'TRAVEL') {
							return 'Travel';
						} if (value == 'DEPARTMENTAL') {
							return 'Departmental';
						} if (value == 'GENERAL') {
							return 'General';
						}
					} else {
						return '<a href="#">' + "View" + '</a>';
					}
				}
			}
		}
	},{
		header : getCommonTranslation('ORGANIZATION_NAME'),
		dataIndex : 'organizationName',
		flex : 1,
	},{
		header : getCommonTranslation('DISBURSMENT_MODE'),
		dataIndex : 'disbursementMode',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ACD'){
					return 'Through The academy';
				}
				if(value == 'DIR'){
					return  'Direct';
				}
			}
		}
	}]
});