/**
 * @author Rohit Sharma
 */
Ext.define('Academia.view.scholarship.scholarshipmaster.DocsAndRefDetailsWindow', {
    extend: 'Ext.window.Window',
    alias: 'widget.docsAndRefDetailsWindow',
    modal: true,
    resizable: false,
    title: getFeeAndPaymentCommonTranslation('DOCS_AND_REF_DETAILS'),
    items: [{
        xtype: 'form',
        plugins: "formlabelrequired",
        defaults: {
            labelAlign: 'top'
        },
        items: [{
			xtype : 'hidden',
			itemId : 'document_hidden_field',
			name : 'id'
		}, {
			xtype : 'hidden',
			name : 'module'
		}, {
			xtype : 'hidden',
			name : 'entityType'
		}, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'selectDocument',
                itemId: 'selectDocument',
                store: 'scholarships.ScholarshipDocumentNameStore',
                fieldLabel: getFeeAndPaymentCommonTranslation('DOCUMENT_NAME'),
                valueField: 'id',
                displayField: 'value',
                editable: false,
                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                enableKeyEvents: 'true',
                allowBlank: false,
                forceSelection: true,
                listConfig: {
                    listeners: {
                        beforeshow: function (picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                            picker.maxWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function () {
                        return '<div class="search-item">' +
                            '{value}' +
                            '</div>';
                    }
                }
            }, {
                xtype: 'customcombobox',
                name: 'applicability',
                itemId: 'applicability',
                store: Ext.create('Ext.data.Store', {
                	fields: ['id', 'value'],
                	data: [{
                		id: 'MANDATORY',
                		value: getCommonTranslation('MANDATORY')
                	}, {
                		id: 'OPTIONAL',
                		value: getCommonTranslation('OPTIONAL')
                	}]
                }),
                fieldLabel: getFeeAndPaymentCommonTranslation('APPLICABILITY'),
                valueField: 'id',
                displayField: 'value',
                editable: false,
                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                allowBlank: false,
                forceSelection: true,
                listConfig: {
                    listeners: {
                        beforeshow: function (picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                            picker.maxWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function () {
                        return '<div class="search-item">' +
                            '{value}' +
                            '</div>';
                    }
                }
            }]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
            defaults: {
                labelAlign: 'top',
                width: 256
            },
            layout: {
                type: 'hbox'
            },
            items: [{
                xtype: 'customcombobox',
                name: 'applicableTo',
                itemId: 'applicableTo',
                store: Ext.create('Ext.data.Store', {
                	fields: ['id', 'value'],
                	data: [{
                		id: 'APPLICANT',
                		value: getFeeAndPaymentCommonTranslation('APPLICANT')
                	}, {
                		id: 'STUDENT',
                		value: getFeeAndPaymentCommonTranslation('STUDENT')
                	}]
                }),
                fieldLabel: getFeeAndPaymentCommonTranslation('APPLICABLE_TO'),
                valueField: 'id',
                displayField: 'value',
                editable: false,
                triggerCls: Ext.baseCSSPrefix + 'x-form-trigger',
                allowBlank: false,
                forceSelection: true,
                value: 'STUDENT',
                listConfig: {
                    listeners: {
                        beforeshow: function (picker) {
                            picker.minWidth = picker.up('combobox').getSize().width;
                            picker.maxWidth = picker.up('combobox').getSize().width;
                        }
                    },
                    loadingText: getCommonTranslation('SEARCHING'),
                    emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                    getInnerTpl: function () {
                        return '<div class="search-item">' +
                            '{value}' +
                            '</div>';
                    }
                }
            }, {
                xtype: 'fieldcontainer',
                width: 'auto',
                defaults: {
                    labelAlign: 'top',
                    width: 256
                },
                items: [{
                    xtype: 'filefield',
                    ui: 'CustomBtnThird',
                    fieldLabel: getFeeAndPaymentCommonTranslation('REFERENCE_DOCUMENT'),
                    buttonText: getFeeAndPaymentCommonTranslation('UPLOAD'),
                    itemId: 'uploadFileField',
                    name: 'file',
                    validateOnChange: true,
                    listeners: {
                        change: function (fileField, value) {
                            value = value.replace('C:\\fakepath\\', '');
                            var newValue = value.replace(/ +/g, " ").split(' ').join('_');
                            fileField.setRawValue(newValue);
                            if (!isNullOrEmpty(newValue)) {
                                var extension = newValue.substring(newValue.lastIndexOf('.') + 1).toLowerCase();
                                var baseController = Academia.getApplication().getController('Academia.controller.base.BaseController');
                                if (!baseController.isValidFileExtension(extension)) {
                                    fileField.reset();
                                    showWarningMessage(getCommonTranslation('ALERT'), getCommonTranslation('BDU_PLEASE_UPLOAD_CSV_FILE'));
                                }
                            }
                        }
                    }
                }, {
                	xtype: 'button',
                	text: '',
                	itemId: 'documentLink',
                	hidden: true,
                	cls: 'hyperlinkBtn'
                }]
            }]
        }, {
            xtype: 'checkboxfield',
            labelAlign: 'right',
            itemId: 'isAllowUplaod',
            boxLabel: getFeeAndPaymentCommonTranslation('ALLOW_UPLOAD'),
            name: 'isAllowUplaod',
            inputValue: true,
            uncheckedValue: false,
            width: 300,
            checked: true
        }, {
            xtype: 'textarea',
            fieldLabel: getFeeAndPaymentCommonTranslation('REMARKS'),
            name: 'remark',
            itemId: 'remark',
            width: 320,
            maxLength: 1000,
            enforceMaxLength: true
        }, {
            xtype: 'fieldcontainer',
            width: '100%',
            cls: 'windowBtnPos',
            items: [{
                xtype: 'button',
                text: getCommonTranslation('SAVE'),
                itemId: 'saveDocumentBtn',
                ui: 'CustomBtnSubmit',
                scale: CONSTANTS.BUTTONSIZE,
                formBind: true
            }, {
                xtype: 'button',
                text: getCommonTranslation('CANCEL'),
                itemId: 'cancleBtn',
                buttonAlign: 'right',
                ui: 'CustomBtnCancel',
                scale: CONSTANTS.BUTTONSIZE,
                listeners: {
                    click: function (btn) {
                        btn.up('window').close();
                    }
                }
            }]
        }]
    }]
});