/**
 * Screen which contains the Search filters of the Scholarship MAster.
 * @author Akshay.Kalbhor
 */
var IntellimaliStatus =  Ext.create('Ext.data.Store', {
    fields: ['value', 'name'],
    data: [{ 
		id:'ALL',
		value:'All' 
	},{
		id:'PENDING',
		value:'Pending' 
	},{
		id:'PROCESSED',
		value:'Processed' 
	}]
});

Ext.define('Academia.view.scholarship.scholarshipmaster.IntellimaliSearchFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.intellimalisearchfilter',
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
	defaults: {
		labelAlign: 'top',
		width: 256
	},
	 items: [{
	        xtype: 'form',
	        cls: 'customSearchInnerPanel',
	        itemId: 'intellimaliForm',
	        plugins : "formlabelrequired",
	        width: '100%',
        items: [{
        	xtype:'fieldcontainer',
    		width: '100%',
    		layout : {
    			type : 'hbox'
    		},
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
                xtype: 'multiselectcombofield',
                name: 'intellimaliBrandCampusName',
                itemId: 'intellimaliBrandCampusName',
                fieldLabel: getCommonTranslation('BRAND_CAMPUS'),
                valueField: 'id',
    			displayField: 'value',
    			width: 536,
    			autoloadStore: false,
      			matchFieldWidth:true,
      			allowBlank : false,
    			queryParam:'qry',
    			minChars:3,
    			typeAhead:true,
    			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
    			enableKeyEvents  : 'true',
    			hideTrigger:false,
    			forceSelection:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					},
    					afterRender: function(combo){
    						combo.getStore().on("load", function(store, items){
    							if(items.length==0)
    								Ext.select('.x-boundlist-item').elements[0].hidden = true;
    							else
    								Ext.select('.x-boundlist-item').elements[0].hidden = false;
    				        });
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
    			},
    			listeners  :{
            		render : function(combo){
            			var store=Ext.create('Academia.store.user.UserAcademyLocationStore');
            			combo.bindStore(store)
            		}
            	}
            }]
        	}, {
            xtype: 'fieldcontainer',
            width: '100%',
            layout: 'hbox',
            defaults: {
                width: 256,
                labelAlign: 'top'
            },
            items: [{
    			xtype : 'customcombobox',
    			fieldLabel : getCommonTranslation('ACCOUNTING_YEAR'),
    			name : 'intellimaliAccountingYear',
    			itemId : 'intellimaliAccountingYear',
    			displayField:'accountingYear',
    			valueField:'id',
    			width: 256,
    			editable: false,
    			allowBlank:false,
    			forceSelection:true,
    			store: 'feeandpayment.accountingConfigurationMapping.AccountingYearForSearchFilterStore'
    		},{
    			xtype: 'customcombobox',
    			name: 'student',
    			itemId:'student',
    			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
    			store: 'scholarships.IntellimaliStudentStore',
    			valueField: 'id',
    			displayField: 'valueCode',
    			queryParam:'studentNameOrCode',
    			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
    			enableKeyEvents  : 'true',
    			minChars:3,
    			typeAhead:false,
    			forceSelection:true,
    			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
    			triggerAction: '',
    			hideTrigger:false,
    			listConfig: {
    				listeners: {
    					beforeshow: function(picker) {
    						picker.minWidth = picker.up('combobox').getSize().width;
    					}
    				},
    				loadingText: getCommonTranslation('SEARCHING'),
    				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
    				getInnerTpl: function() {
    					return '<div class="search-item">' +
    					'{studentCode}/{studentName}' +
    					'</div>';
    				}
    			}
    		}]
        	}, {
                xtype: 'fieldcontainer',
                layout: 'hbox',
                width: '100%',
                defaults: {
                    width: 256,
                    labelAlign: 'top'
                },
                 items: [{
         			xtype: 'datefield',
        			name: 'fromdate',
        			itemId:'fromdate',
        			vtype: 'daterange',
        			endDateField: 'todate',
        			fieldLabel: getFeeAndPaymentCommonTranslation('FROM_DATE'),
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			}
        		},{
        			xtype: 'datefield',
        			name: 'todate',
        			itemId:'todate',
        			vtype: 'daterange',
        			startDateField: 'fromdate',
        			fieldLabel: getFeeAndPaymentCommonTranslation('TILL_DATE'),
        			listeners: {
        				render: function(field) {
        					return dateFormatRender(field);
        				}
        			}
        		}]
    	}, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            width: 256,
            labelAlign: 'top'
        },
        items: [{
			xtype: 'customcombobox',
			name: 'fundAllocation',
			itemId:'fundAllocation',
			fieldLabel: getCommonTranslation('FUND_ALLOCATION'),
			store:'scholarships.FundAllocation',
			valueField: 'id',
			displayField: 'value',
			typeAhead:true,
			forceSelection:true 
		},{
			xtype: 'customcombobox',
			name: 'status',
			itemId:'statusItemId',
			fieldLabel: getCommonTranslation('STATUS'),
			store:IntellimaliStatus,
			valueField: 'id',
			displayField: 'value',
			forceSelection:true,
            editable: false
		}]
        }, {
            xtype: 'fieldcontainer',
            width: 'auto',
    		layout : {
    			type : 'hbox'
    		},
			cls: 'customSearchPanelBtnsFieldContainerCls',
            items: [{
    			xtype: 'button',
    			text: getCommonTranslation('SEARCH'),
    			itemId: 'searchBtn',
    			//buttonAlign: 'left',
    			ui: 'CustomBtnSubmit',
    			formBind: true,
    			scale: CONSTANTS.BUTTONSIZE,
    			margin: '0 16 0 0'
    		},{
    			xtype: 'button',
    			text: getCommonTranslation('RESET'),
    			itemId: 'resetBtn',
    			ui: 'CustomBtnCancel',
    			scale: CONSTANTS.BUTTONSIZE   
    		}]
        }]
	 }]
});