/**
 * 
 * This component is used to show add new recored tab on scholarship receipt
 */
Ext.define('Academia.view.scholarship.scholarshipreceipt.ScholarshipReceiptForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.scholarshipreceiptform',    
    plugins : "formlabelrequired",
    items: [{
                  xtype: 'hidden',
                    itemId: 'hidden_receipt_id',
                    name: 'id'
                }, {
                    xtype: 'hidden',
                    itemId: 'version',
                    name: 'version'
                },{
			    	xtype: 'fieldcontainer',
				    width: 'auto',
				    defaults: {
				    	labelAlign: 'top',
				    	width: 256
				    },
				    layout: {
				    	type: 'hbox'
				    },
					items: [{
						xtype: 'customcombobox',
						name: 'scholarshipId',
	                    itemId: 'cmbSelectScholarship',
	                    fieldLabel: getCommonTranslation('SCHOLARSHIP'), //Scholarship
	                    store:'scholarships.AddAwardeeScholarshipComboStore',
	                    valueField: 'id',
	                    displayField: 'scholarshipName',
	                    editable: false,
	                    // //Select Scholarship
	                    queryMode: 'local',
	                    triggerAction: 'all',
	                    forceSelection: true,
	                    allowBlank: false							                    	                    	                    	                   
	                },{
	                	xtype: 'customcombobox',
						name: 'scholarshipAwardeeId',
	                    itemId: 'cmbScholarshipAwardee',
	                    fieldLabel: getCommonTranslation('AWARDEE'), //Awardee
	                    store: 'scholarships.ScholarshipAwardeeListStore',
	                    valueField: 'id',
	                    displayField: 'value',
	                    editable: false,
	                    // //Select Awardee
	                    queryMode: 'local',
	                    triggerAction: 'all',
	                    forceSelection: true,
	                    allowBlank: false
	                }]
                },{
			    	xtype: 'fieldcontainer',
				    width: 'auto',
				    defaults: {
				    	labelAlign: 'top',
				    	width: 256
				    },
				    layout: {
				    	type: 'hbox'
				    },
					items: [{
						xtype: 'customcombobox',
						name: 'transactionType',
	                    itemId: 'cmbTransactionType',
	                    fieldLabel: getCommonTranslation('TRANSACTION_TYPE'), //Transaction Type
	                    store : 'scholarships.TransactionTypes',
	                    valueField: 'id',
	                    displayField: 'value',
	                    editable: false,
	                    // //Transaction Type
	                    queryMode: 'local',
	                    triggerAction: 'all',
	                    forceSelection: true,
	                    allowBlank: false
	                },{
	                	xtype: 'datefield',
	                    name: 'transactionDate',
	                    itemId: 'transactionDate',
	                    fieldLabel: getCommonTranslation('TRANSACTION_DATE'), //Transaction Date
	                    editable: false,	       
	                    maxValue:new Date(),
	                    // //Transaction Date
	                  //--submitFormat: CONSTANTS.DATE_FORMAT,
	                    listeners: {
	                    	render: function(field) {
	                    		return dateFormatRender(field);
	                    	}
	                    },
	                    allowBlank: false
	                }]
                },{
			    	xtype: 'fieldcontainer',
				    width: 'auto',
				    defaults: {
				    	labelAlign: 'top',
				    	width: 256
				    },
				    layout: {
				    	type: 'hbox'
				    },
					items: [{
	                    xtype: 'textfield',
	                    name: 'instrumentNo',
	                    itemId: 'instrumentNo',
	                    fieldLabel: getCommonTranslation('INSTRUMENT_NO'), //Instrument No.	                    
	                    allowBlank: false,
						maxLength: 40,
	                    minValue:0	                    
	                },{	                	                   
	                	xtype: 'datefield',
	                    name: 'instrumentDate',
	                    itemId: 'instrumentDate',
	                    fieldLabel: getCommonTranslation('INSTRUMENT_DATE'), //Instrument Date
	                    editable: false,	                    	                    
	                    // //Instrument Date
	                  //--submitFormat: CONSTANTS.DATE_FORMAT,
	                    listeners: {
	                    	render: function(field) {
	                    		return dateFormatRender(field);
	                    	}
	                    },
	                    allowBlank: false
	                }]
	             },{
				    	xtype: 'fieldcontainer',
					    width: 'auto',
					    defaults: {
					    	labelAlign: 'top',
					    	width: 256
					    },
					    layout: {
					    	type: 'hbox'
					    },
						items: [{
		                    xtype: 'numberfield',
		                    name: 'transactionAmount',
		                    itemId: 'transactionAmount',
		                    fieldLabel: getCommonTranslation('TRANSACTION_AMOUNT'), //Transaction Amount
		                    allowBlank: false,
		                    minValue:0		                    
		                },{
		                    xtype: 'textfield',
		                    name: 'instrumentDrawnOn',
		                    itemId: 'instrumentDrawnOn',
		                    fieldLabel: getCommonTranslation('INSTRUMENT_DRWAN_ON'), //Instrument Drawn On
		                    allowBlank: false
		                }]
	             },{
				    	xtype: 'fieldcontainer',
					    width: 'auto',
					    defaults: {
					    	labelAlign: 'top',
					    	width: 256
					    },
					    layout: {
					    	type: 'hbox'
					    },
						items: [{
		                    xtype: 'textfield',
		                    name: 'voucherReference',
		                    itemId: 'voucherReference',
		                    fieldLabel: getCommonTranslation('VOUCHER_REF'), //Voucher Reference		                    
		                    editable : false,
		                    allowBlank: false
		                }]            
	             },{
				    	xtype: 'fieldcontainer',
					    width: 'auto',
					    defaults: {
					    	labelAlign: 'top'
					    },					    
						items: [{
					        xtype: 'textarea',
					        name: 'transactionNote',
					        itemId: 'transactionNote',
					        fieldLabel: getCommonTranslation('ADD_NOTE'), //Add Note
					        maxLength:250,
					        layout: 'anchor',
					        width: 536,
					        height: 100
						}]     					
			    },{
		        	xtype:'fieldcontainer',
		        	width:'100%',		            
		        	cls:'windowBtnPos',
		            items: [{
			            xtype: 'button',
			            text: getCommonTranslation('SAVE'),
			            itemId: 'btnSaveScholarshipReceiptForm',			            			            			          
			            ui: 'CustomBtnSubmit',
			            scale: CONSTANTS.BUTTONSIZE,
			            formBind: true
			        },{
			            xtype: 'button',
			            text: getCommonTranslation('CANCEL'),
			            itemId: 'btnCancelScholarshipReceiptForm',
			            ui: 'CustomBtnCancel',
			            scale: CONSTANTS.BUTTONSIZE
			        }]
			    }]
});