
Ext.define('Academia.view.securitysetup.AcademyLocationRoleGridWindow', {
    	extend: 'Ext.window.Window',
    	alias: 'widget.academylocationrolegridwindow',
    	modal : true,
    	resizable:true,
    	autoScroll: true,
    	height: '50%',
    	width: '55%',
    	title:getCommonTranslation('ACADEMY_LOCATION_AND_ROLES'),
    	items: [{
    		xtype: 'grid',
    		store:'securitysetup.AcademyLocationByRoleStore',
    		frame: false,
    		border:true,
    		autoScroll: false,
    		itemId:'academyLocationRoleGridId',
    		viewConfig : {
    			stripeRows : CONSTANTS.STRIPEROWS
    		},
    		features: [{
    	        ftype: 'summary',
    	        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW 
    	    }],
    		dockedItems : [{
    			xtype : 'toolbar',
    			dock : 'bottom',
    			items : [{
    				xtype: 'custompagingtoolbar',
    				plugins:['pagesize'],
    				store : 'securitysetup.AcademyLocationByRoleStore',
    				emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo : true
    			}]
    		}],
    		columns: [{
    			header : getCommonTranslation('ACADEMY_LOCATION'),
    			dataIndex : 'academyLocation',
    			flex : 1,  
    		}, {
    			header : getCommonTranslation('ROLE'),
    			dataIndex : 'roles',
    			flex : 1,
    			renderer: function(value) {
    	            return getCommonTranslation(value);
    	        }
    		}] 	
    	}]
    });
