Ext.define('Academia.view.securitysetup.AssignAcademyLocationForm', {
    extend: 'Ext.window.Window',
    alias: 'widget.useracademylocation',
    title: getCommonTranslation('ASSIGN_ACADEMY_LOCATION'),
    autoScroll: true,
    maxHeight: 600,
    frame: true,
    modal: true,
    plugins : "formlabelrequired",
    width: 450,
    items: [{
        xtype: 'form',
        itemId : 'userAcademyLocatioFormId',
        defaults: {
            labelAlign: 'top',
            width: 256
        },
        items: [{
        	  xtype: 'hidden',
    		  name:'id'
    	},{
      	  xtype: 'hidden',
		  name:'version'
    	},{
      	  xtype: 'hidden',
		  name:'userId'
    	},{
        	xtype:'customcombobox',
            fieldLabel: getCommonTranslation('ACADLOCTT'),
            name: 'academyLocationId',
			itemId:'academy_name',
			store : 'common.AllActiveAcademyLocationStore',
			valueField : 'id',
			displayField : 'academyLocationName',
			queryParam:'name',
			minChars:3,
			typeAhead:false,
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{academyLocationName}' +
					'</div>';
				}
			}
        }, {
            xtype: 'datefield',
            name: 'startDate',
            fieldLabel: getCommonTranslation('START_DATE'),
            vtype: 'daterange',
            itemId: 'startDate',
            endDateField: 'tillDate',
            allowBlank: false,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
          //--submitFormat: CONSTANTS.DATE_FORMAT
        }, {
            xtype: 'datefield',
            name: 'tillDate',
            fieldLabel: getCommonTranslation('END_DATE'),
            itemId: 'tillDate',
            vtype: 'daterange',
            startDateField: 'startDate',
            listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat: CONSTANTS.DATE_FORMAT
        }, {
            xtype: 'checkboxfield',
            fieldLabel: getCommonTranslation('PRIMARY_ACADEMY_LOCATION'),
            boxLabel: getCommonTranslation('USER_MARK_PRIMARY_AL'),
            name: 'whetherPrimary',
            itemId: 'whetherPrimary',
            inputValue:true,
        	uncheckedValue:false,
        	value:false,
        	style: 'float:left;',
        },{
			xtype:'fieldcontainer',
			width:'100%',
			cls:'windowBtnPos',
			items: [{
            xtype: 'button',
        	formBind : true,
            text: getCommonTranslation('SAVE'),
            itemId: 'saveAcademyLocation',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE
        },{
			xtype: 'button',
			text: getCommonTranslation('CANCEL'),
			ui: 'CustomBtnCancel', 
			itemId: 'cancelBtn',
			scale: CONSTANTS.BUTTONSIZE

		}]
       }]
    }]
});